﻿#include <fcntl.h>
#include <linux/input.h>
#include <math.h>
#include <pthread.h>
#include <stdbool.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/ioctl.h>
#include <sys/stat.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <time.h>
#include <unistd.h>

#define MOUNT_POINT "/mnt/exUDISK/swuUpdate"
#define INTERVAL 1 // 检查间隔，单位：秒
#define BUFFER_SIZE 2048
#define ENV_CMD "fw_printenv -n %s 2>/dev/null"
#define SET_CMD "fw_setenv %s %s"
void executeSync(int value) {
  system("sync");
  return;
}

bool get_env(const char* name, char* buf, size_t len) {
    char cmd[128];
    snprintf(cmd, sizeof(cmd), ENV_CMD, name);
    
    FILE* fp = popen(cmd, "r");
    if (!fp) return false;
    
    bool ret = (fgets(buf, len, fp) != NULL);
    pclose(fp);
    
    // 去除换行符
    buf[strcspn(buf, "\n")] = '\0';
    return ret;
}

int checkPartition(int value) {
  printf("++++++++++++++start to checkPartition\n");
  FILE *fp_check;
  char buffer[BUFFER_SIZE] = {0};
  size_t bytesRead;
  int checkFlag = 0;
  char partitionValue[1] = {0};
  // 使用 popen 执行命令
  // // 假设这是一个有效的命令
  fp_check =
      popen("fw_printenv | grep 'appAB='", "r"); // 假设这是一个有效的命令
  if (fp_check == NULL) {
    perror("popen failed");
    return 1;
  }

  // 读取扫描结果
  while (fgets(buffer, sizeof(buffer), fp_check)) {
    printf("++++++++++++++popen checkPartition result is %s", buffer);
  }
  partitionValue[0] = buffer[6];
  printf("+++++++++partitionValue=%s", partitionValue);
  printf("+++++++++partitionValue=%c", partitionValue[0]);
  if (partitionValue[0] == 'A') {
    checkFlag = 0; //表示当前分区是A分区
  } else {
    checkFlag = 1; //表示当前分区是B分区
  }

  if (ferror(fp_check)) {
    perror("fread error");
  }
  pclose(fp_check);
  printf("++++++++++++++checkFlag=%d\n", checkFlag);
  return checkFlag;
}

// int checkPartition(int value) {
//   printf("++++++++++++++start to checkPartition\n");
//   FILE *fp_check;
//   char buffer[BUFFER_SIZE] = {0};
//   size_t bytesRead;
//   int checkFlag = 0;
//   char partitionValue[1] = {0};
//   // 使用 popen 执行命令
//   // // 假设这是一个有效的命令
//   fp_check =
//       popen("fw_printenv | grep 'boot_partition='", "r"); // 假设这是一个有效的命令
//   if (fp_check == NULL) {
//     perror("popen failed");
//     return 1;
//   }

//   // 读取扫描结果
//   while (fgets(buffer, sizeof(buffer), fp_check)) {
//     printf("++++++++++++++popen checkPartition result is %s", buffer);
//   }
//   partitionValue[0] = buffer[6];
//   printf("+++++++++partitionValue=%s", partitionValue);
//   printf("+++++++++partitionValue=%c", partitionValue[0]);
//   if (partitionValue[0] == 'bootA') {
//     checkFlag = 0; //表示当前分区是A分区
//   } else {
//     checkFlag = 1; //表示当前分区是B分区
//   }

//   if (ferror(fp_check)) {
//     perror("fread error");
//   }
//   pclose(fp_check);
//   printf("++++++++++++++checkFlag=%d\n", checkFlag);
//   return checkFlag;
// }

int findSwuFile(int value) {
  //   printf("+++++++++++++++++findSwuFile is OK!\n");
  printf("++++++++++++++start to findSwuFile\n");
  FILE *fp_in;
  char buffer[BUFFER_SIZE] = {0};
  size_t bytesRead;
  int findSwuFile = 0;
  // system("cp /mnt/exUDISK/swuUpdate/msdk_t113_bcmdhd /mnt/UDISK");
  // system("chmod -R 777 /mnt/UDISK/msdk_t113_bcmdhd");
  // system("sync");
  // 使用 popen 执行命令
  if (value == 0) {
    fp_in = popen("find /mnt/exUDISK/swuUpdate/*.swu | grep 'openwrt_t113_evb1-ab.swu'","r"); // 假设这是一个有效的命令
      if (fp_in == NULL) {
      perror("popen failed");
      return 2;
      }

      // 读取扫描结果
      if (fgets(buffer, sizeof(buffer), fp_in) != NULL) {
        printf("++++++++++++++popen findSwuFile result is %s", buffer);
        findSwuFile = 0; // 表示查找swu文件成功
      }
      // 检查并处理任何可能的错误
      else {
        findSwuFile = 2; // 表示查找swu文件失败
      }
  }
  else{
    fp_in = popen("find /mnt/exUDISK/swuUpdate/*.swu | grep 'openwrt_t113_evb1-ba.swu'","r"); // 假设这是一个有效的命令
      if (fp_in == NULL) {
        perror("popen failed");
        return 2;
      }

      // 读取扫描结果
      if (fgets(buffer, sizeof(buffer), fp_in) != NULL) {
        printf("++++++++++++++popen findSwuFile result is %s", buffer);
        findSwuFile = 1; // 表示查找swu文件成功
      }
      // 检查并处理任何可能的错误
      else {
        findSwuFile = 2; // 表示查找swu文件失败
      }
  }

  if (ferror(fp_in)) {
    perror("fread error");
  }
  pclose(fp_in);
  printf("++++++++++++++findSwuFile=%d\n", findSwuFile);
  return findSwuFile;
}

int executeUpdate(int value) {
  printf("++++++++++++++start to executeUpdate\n");
  FILE *fp_update;
  char buffer[BUFFER_SIZE] = {0};
  size_t bytesRead;
  int updateFlag = 0;
  // 使用 popen 执行命令
  // fp_update = popen("swupdate -v -i /mnt/exUDISK/swuUpdate/openwrt_t113_evb1-ab.swu","r");
  // // 假设这是一个有效的命令
  if (value == 0) {
    fp_update = popen("swupdate -v -i /mnt/exUDISK/swuUpdate/openwrt_t113_evb1-ab.swu -e stable,now_A_next_B | grep 'SWUPDATE successful !'","r"); // 假设这是一个有效的命令
  }
  else if(value == 1){
     fp_update = popen("swupdate -v -i /mnt/exUDISK/swuUpdate/openwrt_t113_evb1-ba.swu -e stable,now_B_next_A | grep 'SWUPDATE successful !'","r"); // 假设这是一个有效的命令
  }
  else{
    return 0;
  }
  if (fp_update == NULL) {
    perror("popen failed");
    return 1;
  }

  // 读取扫描结果
  while (fgets(buffer, sizeof(buffer), fp_update)) {
    printf("++++++++++++++popen executeUpdate result is %s", buffer);
    updateFlag = 1; // 表示swu升级成功
  }
  // // 检查并处理任何可能的错误
  // else {
  //   updateFlag = 0; // 表示swu升级失败
  // }
  if (ferror(fp_update)) {
    perror("fread error");
  }
  pclose(fp_update);
  printf("++++++++++++++updateFlag=%d\n", updateFlag);
  return updateFlag;
}

// 执行系统命令的函数
int executeSystemCommand(const char *cmd) {
    int status = system(cmd);
    if (status == -1) {
        perror("system() failed");
        return -1;
    } else {
        printf("命令执行状态码: %d\n", WEXITSTATUS(status));
        return status;
    }
}

//传入一个参数str，打印str
int executePrint(const char *str) {
    printf("%s", str); // 使用固定格式字符串
}

void systemReboot(int value) {
  system("sync");
  system("reboot");
  return;
}

int main(int value) {
  printf("There are in systemCtrl main function!");
  int num=0;
  num=executeUpdate(1);
  printf("num=%d\n",num);
  return 0;
}

// void runswuUpdate(int value) {
//   system("swupdate -v -i /mnt/exUDISK/swuUpdate/openwrt_t113_evb1-ab.swu -e "
//          "stable,now_B_next_A");
//   return;
// }

// void execute_upgrade() {
//   // 假设执行升级的命令是 "swu_update"
//   char *upgrade_command[] = {"/mnt/exUDISK/swuUpdate/openwrt_t113_evb1-ab.swu", NULL};
//   pid_t pid = fork();
//   if (pid == 0) { // 子进程
//     execvp(upgrade_command, upgrade_command);
//     printf("Error executing upgrade command.\n");
//     _exit(EXIT_FAILURE);
//   } else if (pid > 0) {
//     // 父进程等待子进程结束
//     wait(NULL);
//   }
// }

// int check_for_swu() {
//   char find_command[128];
//   snprintf(find_command, sizeof(find_command), "find %s -name '*.swu'",
//            MOUNT_POINT);

//   FILE *fp = popen(find_command, "r");
//   if (fp == NULL) {
//     perror("popen failed");
//     return -1;
//   }
//   char line[256];
//   if (fgets(line, sizeof(line), fp) != NULL) {
//     // 找到了.swu文件
//     pclose(fp);
//     return 1;
//   }
//   pclose(fp);
//   return 0;
// }

// void systemMain(int value) {
//   printf("value=%d\n", value);
//   if (value == 0) {
//     return 0;
//   }
//   while (1) {
//     if (check_for_swu()) {
//       printf("Found .swu file, starting upgrade...\n");
//       execute_upgrade();
//       printf("Upgrade completed, exiting.\n");
//       break;
//     }
//     printf("Checking for .swu file...\n");
//     sleep(INTERVAL);
//   }
//   return 0;
// }
