var dlfcn = require("dlfcna.js");
//console.log(dlfcn)
var funcs = [
    ["soundInit", "v"],
    ["soundOn", "v"],

    ["pwmInit", "i"],
    ["pwmLv1", "i"],
    ["pwmLv2", "i"],
    ["pwmLv3", "i"],
    ["pwmLv4", "i"],
    ["pwmLv5", "i"],
    ["pwmLv6", "i"],
    ["pwmOff", "i"],
    ["pwmOn", "i"],


    ["gpio1On", "vi"],
    ["gpio1Off", "vi"],
    ["gpio2On", "vi"],
    ["gpio2Off", "vi"],
    ["gpio3On", "vi"],
    ["gpio3Off", "vi"],
    ["gpio4On", "vi"],
    ["gpio4Off", "vi"],
    ["gpio5On", "vi"],
    ["gpio5Off", "vi"],
    ["gpio6On", "vi"],
    ["gpio6Off", "vi"],
    ["gpio7On", "vi"],
    ["gpio7Off", "vi"],


    ["insModEncoder", "v"],
    ["rmModEncoder", "v"],
    ["gpioUnexport", "v"],
    ["gpioInit", "v"],

];
//console.log("in factory_rd190_factory.js")
function register() {
    //console.log("will register rd190_factory.so")
    if (globalThis.Simu.En == 1) {
        return undefined
    }
    var isSuccess = dlfcn.register("@native.rd190_factory", "./lib/factory/rd190_factory.so", funcs);
    if (isSuccess) {
        //console.log("load so successfully")
        var rd190_factory = require("@native.rd190_factory");
        return rd190_factory
    } else {
        //console.log("load so failed")
    }
    return undefined;
}
var rd190_factory = register();

function pwmInit() {
    if (globalThis.Simu.En == 1) {
        return 0
    }
    rd190_factory.pwmInit()
}

function soundInit() {
    if (globalThis.Simu.En == 1) {
        return 0
    }
    rd190_factory.soundInit()
}

function soundOn() {
    if (globalThis.Simu.En == 1) {
        return 0
    }
    rd190_factory.soundOn()
}
function pwm(val) {
    //console.log("pwm:" + val)
    if (globalThis.Simu.En == 1) {
        return 0
    }
    if (val == 0) {
        rd190_factory.pwmOff()
    }
    if (val == 1) {
        rd190_factory.pwmLv1()
        rd190_factory.pwmOn()
    }
    if (val == 2) {
        rd190_factory.pwmLv2()
        rd190_factory.pwmOn()
    }
    if (val == 3) {
        rd190_factory.pwmLv3()
        rd190_factory.pwmOn()
    }
    if (val == 4) {
        rd190_factory.pwmLv4()
        rd190_factory.pwmOn()
    }
    if (val == 5) {
        rd190_factory.pwmLv5()
        rd190_factory.pwmOn()
    }
    if (val == 6) {
        rd190_factory.pwmLv6()
        rd190_factory.pwmOn()
    }
}
function gpio(index, status) {
    //console.log("index:" + index)
    //console.log("status:" + status)
    if (globalThis.Simu.En == 1) {
        return 0
    }
    if (status == 1) {
        switch (index) {
            case 1: {
                rd190_factory.gpio1On()
                break
            }
            case 2: {
                rd190_factory.gpio2On()
                break
            }
            case 3: {
                rd190_factory.gpio3On()
                break
            }
            case 4: {
                rd190_factory.gpio4On()
                break
            }
            case 5: {
                rd190_factory.gpio5On()
                break
            }
            case 6: {
                rd190_factory.gpio6On()
                break
            }
            case 7: {
                rd190_factory.gpio7On()
                break
            }
            default:
                break
        }
    } else {
        switch (index) {
            case 1: {
                rd190_factory.gpio1Off()
                break
            }
            case 2: {
                rd190_factory.gpio2Off()
                break
            }
            case 3: {
                rd190_factory.gpio3Off()
                break
            }
            case 4: {
                rd190_factory.gpio4Off()
                break
            }
            case 5: {
                rd190_factory.gpio5Off()
                break
            }
            case 6: {
                rd190_factory.gpio6Off()
                break
            }
            case 7: {
                rd190_factory.gpio7Off()
                break
            }
            default:
                break
        }
    }
}
function gpioInit() {
    rd190_factory.gpioInit()
}
function insmodEncoder() {
    rd190_factory.gpioUnexport()
    rd190_factory.insModEncoder()
}
function rmmodEncoder() {
    rd190_factory.rmModEncoder()
    rd190_factory.gpioInit()
}
module.exports = {
    pwmInit: pwmInit,
    soundInit: soundInit,
    soundOn:soundOn,
    pwm: pwm,
    gpio: gpio,
    gpioInit: gpioInit,
    insmodEncoder: insmodEncoder,
    rmmodEncoder: rmmodEncoder,
}
