#include <sys/types.h>
#include <sys/stat.h>
#include <sys/time.h>
#include <fcntl.h>
#include <unistd.h>
#include <stdio.h>
#include <string.h>
#include <sys/ioctl.h>
#include <stdlib.h>
#include <linux/input.h>
#include <pthread.h>
#include <math.h>
#include <time.h>
#include <sys/time.h>

// cmd length
#define CMD_LENGTH 100
// 通用字符串
#define CS_ECHO "echo "
#define CS_REDIRECT " > "
#define CS_IN "in"
#define CS_OUT "out"
#define CS_NORMAL "normal"
#define CS_INVERSE "inverse"
// rtc
#define CS_RTC_DATE "date "
#define CS_RTC_HWCLOCK "hwclock "

#define HWCLOCK_W " -w"
#define DATE_S " -s"
// 公共函数
int retIntBits(int value)
{
    int bit = 0;
    while (1)
    {
        int res = value % 10;
        int resEx = value / 10;
        value /= 10;
        if (res != 0 || resEx != 0)
        {
            bit++;
        }
        else
        {
            if (bit == 0)
            {
                bit = 1;
            }
            return bit;
        }
    }
}
int strToInt(char c)
{
    int res = -1;
    res = c - '0';
    return res;
}
char *intToStr(int value)
{
    int bits = retIntBits(value);
    char *p = (char *)malloc(bits + 1);
    int cnt = 0;
    for (cnt = 0; cnt < bits; cnt++)
    {
        *(p + cnt) = '0' + value / pow(10, bits - cnt - 1);
        value %= (int)pow(10, bits - cnt - 1);
    }
    *(p + cnt) = '\0';
    return p;
}
// 指令构建函数
char *rtcDate(const char *option,
              int year,
              int month,
              int day,
              int hour,
              int minute,
              int second)
{
    char *sValue;
    sValue = intToStr(year);
    char *resString = (char *)malloc(CMD_LENGTH);
    memset(resString, 0, CMD_LENGTH);
    strcat(resString, CS_RTC_DATE);
    strcat(resString, option);
    strcat(resString, " \"");
    strcat(resString, sValue);
    strcat(resString, "-");
    sValue = intToStr(month);
    strcat(resString, sValue);
    strcat(resString, "-");
    sValue = intToStr(day);
    strcat(resString, sValue);
    strcat(resString, " ");
    sValue = intToStr(hour);
    strcat(resString, sValue);
    strcat(resString, ":");
    sValue = intToStr(minute);
    strcat(resString, sValue);
    strcat(resString, ":");
    sValue = intToStr(second);
    strcat(resString, sValue);
    strcat(resString, "\"");
    free(sValue);
    return resString;
}
char *rtcHwclock(const char *option)
{
    char *resString = (char *)malloc(CMD_LENGTH);
    memset(resString, 0, CMD_LENGTH);
    strcat(resString, CS_RTC_HWCLOCK);
    strcat(resString, option);
    return resString;
}
// 指令外部声明函数
void set(int year,
         int month,
         int day,
         int hour,
         int minute,
         int second)
{
    char *p = rtcDate(DATE_S,
                      year,
                      month,
                      day,
                      hour,
                      minute,
                      second);
    printf("set=%s\n", p);
    system(p);
    free(p);

    p = rtcHwclock(HWCLOCK_W);
    printf("set=%s\n", p);
    system(p);
    free(p);
    return;
}

int isRTC(char *name)
{
    int maxlen = 50;
    char buf[50] = {0};
    printf("isRTC function is run!");

    memset(buf, 0, maxlen);

    // system("hwclock\n");

    // system("ls /sys/class/rtc/ | grep rtc1");
    printf("Find RTC Name is %s\n", name);
    FILE *stream = popen("ls /sys/class/rtc/ | grep rtc1", "r");
    if (stream != NULL)
    {
        fread(buf, 1, maxlen, stream);
        char *strp = strstr(buf, name);
        if (strp != NULL)
        {
            printf("RTC Finded!");
            return 1;
        }
    }
    printf("RTC NOT Finded!");
    return 0;
}