#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <stdio.h>
#include <string.h>
#include <sys/ioctl.h>
#include <stdlib.h>
#include <linux/input.h>
#include <pthread.h>

void backlightLv0(void)
{
	// printf("c-backlight off\n");
	system("echo 210 > /sys/class/disp/disp/attr/lcdbl"); /*0~255，值越小，亮度越亮*/
	return;
}

void backlightLv1(void)
{
	// printf("c-backlight off\n");
	system("echo 175 > /sys/class/disp/disp/attr/lcdbl"); /*0~255，值越小，亮度越亮*/
	return;
}

void backlightLv2(void)
{
	// printf("c-backlight off\n");
	system("echo 140 > /sys/class/disp/disp/attr/lcdbl"); /*0~255，值越小，亮度越亮*/
	return;
}

void backlightLv3(void)
{
	// printf("c-backlight off\n");
	system("echo 105 > /sys/class/disp/disp/attr/lcdbl"); /*0~255，值越小，亮度越亮*/
	return;
}

void backlightLv4(void)
{
	// printf("c-backlight off\n");
	system("echo 70 > /sys/class/disp/disp/attr/lcdbl"); /*0~255，值越小，亮度越亮*/
	return;
}

void backlightLv5(void)
{
	// printf("c-backlight off\n");
	system("echo 35 > /sys/class/disp/disp/attr/lcdbl"); /*0~255，值越小，亮度越亮*/
	return;
}

void backlightLv6(void)
{
	// printf("c-backlight off\n");
	system("echo 0 > /sys/class/disp/disp/attr/lcdbl"); /*0~255，值越小，亮度越亮*/
	return;
}
int keypaddev_fd = 0;
int keypaddev_fdex = 0;
int keyValue = 0; //业务逻辑的index

typedef enum
{
	KRY_PSB_LROT = 1, //左旋事件索引值 left rotation
	KRY_PSB_RROT = 2, //右旋事件索引值 right rotation
	KRY_PSB_ENTP = 3, //按钮按下事件索引值 enter press
	KRY_PSB_ENTR = 4, //按钮释放事件索引值 enter release
	KRY_PSB_UPP = 5,  //上拨动触发事件索引值 upper press
	KRY_PSB_UPR = 6,  //上拨动释放事件索引值 upper release
	KRY_PSB_DNP = 7,  //下拨动触发事件索引值 down press
	KRY_PSB_DNR = 8,  //下拨动释放事件索引值 down release
	KRY_PSB_LTP = 9,  //左拨动触发事件索引值 left press
	KRY_PSB_LTR = 10, //左拨动释放事件索引值 left release
	KRY_PSB_RTP = 11, //右拨动触发事件索引值 right press
	KRY_PSB_RTR = 12, //右拨动释放事件索引值 right release
	KRY_PSB_END
} KEY_PSB;
typedef enum
{
	KEY_CODE_ROT = 0,	//旋钮code值
	KEY_CODE_ENT = 103, //按钮code值
	KEY_CODE_UP,		//上拨code值
	KEY_CODE_DN,		//下拨code值
	KEY_CODE_LT,		//左拨code值
	KEY_CODE_RT,		//右拨code值
	KEY_CODE_END
} KEY_CODE;
typedef enum
{
	KEY_VALUE_LROT = 1,	 //左旋value值
	KEY_VALUE_RROT = -1, //右旋value值
	KEY_VALUE_NP = 0,	 //按下value值
	KEY_VALUE_NR = 1,	 //释放value值
	KEY_VALUE_END
} KEY_VALUE;
typedef struct KeyList
{
	int index;
	int code;
	int value;
	int ret;
} RD163A_KEY_LIST;

int retKey(int code, int value)
{
	RD163A_KEY_LIST keyList[] = {
		{0, KEY_CODE_ROT, KEY_VALUE_LROT, KRY_PSB_LROT},
		{1, KEY_CODE_ROT, KEY_VALUE_RROT, KRY_PSB_RROT},
	};

	int cnt = 0;
	for (cnt = 0; cnt < 2; cnt++)
	{
		if (keyList[cnt].code == code)
		{
			if (keyList[cnt].value == value)
			{
				return keyList[cnt].ret;
			}
		}
	}
	return 0;
}
int keyexFlag = 0;
int retKeyex(int code, int value)
{
	RD163A_KEY_LIST keyList[] = {
		{2, KEY_CODE_ENT, KEY_VALUE_NP, KRY_PSB_ENTP},
		{3, KEY_CODE_ENT, KEY_VALUE_NR, KRY_PSB_ENTR},
		{4, KEY_CODE_UP, KEY_VALUE_NP, KRY_PSB_UPP},
		{5, KEY_CODE_UP, KEY_VALUE_NR, KRY_PSB_UPR},
		{6, KEY_CODE_DN, KEY_VALUE_NP, KRY_PSB_DNP},
		{7, KEY_CODE_DN, KEY_VALUE_NR, KRY_PSB_DNR},
		{8, KEY_CODE_LT, KEY_VALUE_NP, KRY_PSB_LTP},
		{9, KEY_CODE_LT, KEY_VALUE_NR, KRY_PSB_LTR},
		{10, KEY_CODE_RT, KEY_VALUE_NP, KRY_PSB_RTP},
		{11, KEY_CODE_RT, KEY_VALUE_NR, KRY_PSB_RTR}};

	int cnt = 0;

	for (cnt = 2; cnt < 10; cnt++)
	{
		if ((keyList[cnt].code == code) && (keyList[cnt].value == value))
		{
			if (value == 0)
			{
				keyexFlag = 1;
				return keyList[cnt].ret;
			}
			if (value == 1)
			{
				keyexFlag = 0;
				return keyList[cnt].ret;
			}
		}
	}
	for (cnt = 0; cnt < 2; cnt++)
	{
		if (keyList[cnt].code == code)
		{
			if ((value == 0) && (keyexFlag == 0))
			{
				return keyList[cnt].ret;
			}
		}
	}
	return 0;
}
void psbHandler(void *p)
{
	// printf("===================into psbHandler======================\n");
	struct input_event in;
	int tempVal = 0;
	while (1)
	{
		// printf("psbHandler\n");
		if (read(keypaddev_fd, &in, sizeof(struct input_event)) > 0)
		{
			// printf("keypaddev_read		KEY_CODE=%d		KEY_NUM=%d\n", in.code, in.value); // psb的数值
			tempVal = retKey(in.code, in.value);
			if (tempVal == 0)
			{
			}
			else
			{
				keyValue = tempVal;
				// printf("keyValue=%d\n",keyValue);
			}
		}
		usleep(1 * 1000);
	}
	return keyValue;
}
void psbexHandler(void *p)
{
	// printf("======================into psbexHandler================\n");
	struct input_event in;
	int tempVal = 0;
	while (1)
	{
		// printf("psbexHandler\n");
		if (read(keypaddev_fdex, &in, sizeof(struct input_event)) > 0)
		{
			// printf("keypaddev_readex	KEY_CODE=%d		KEY_NUM=%d	\n", in.code, in.value); // psb的数值

			tempVal = retKeyex(in.code, in.value);
			if (tempVal == 0)
			{
			}
			else
			{
				keyValue = tempVal;
				// printf("keyValue=%d\n",keyValue);
			}
		}
		usleep(1 * 1000);
	}
	return keyValue;
}
void psbInit(void)
{
	// printf("enter psb init.\n");
	pthread_t thread;
	// printf("pthread_t create.\n");
	keypaddev_fd = open("/dev/input/event1", O_RDONLY); //打开event1
	// printf("has opened event1.\n");
	if (keypaddev_fd <= 0)
	{
		// printf("unable open keypad interface,error code:%d.\n", keypaddev_fd);
		return;
	}
	// printf("open event1 successfully,will create pthread.\n");
	pthread_create(&thread, NULL, psbHandler, NULL); //用handler读和处理
	// printf("create pthread successfully.\n");
	return;
}

void psbexInit(void)
{
	// printf("enter psb init.\n");
	pthread_t thread;
	// printf("pthread_t create.\n");
	keypaddev_fdex = open("/dev/input/event2", O_RDONLY); //打开event2
	// printf("has opened event2.\n");
	if (keypaddev_fdex <= 0)
	{
		// printf("unable open keypad interface,error code:%d.\n", keypaddev_fdex);
		return;
	}
	// printf("open event2 successfully,will create pthread.\n");
	pthread_create(&thread, NULL, psbexHandler, NULL); //用handler读和处理
	// printf("create pthread successfully.\n");
	return;
}

int psbGetValue(void)
{
	return keyValue;
}
void psbClearValue(void)
{
	keyValue = 0;
	return;
}

void pwmInit(void)
{
	// printf("c-pwm:init\n");
	system("echo 1 > /sys/class/pwm/pwmchip0/export");				 /*启动pwm1功能位*/
	system("echo 600000 > /sys/class/pwm/pwmchip0/pwm1/period");	 /*设置pwm1的周期，单位是ns*/
	system("echo 300000 > /sys/class/pwm/pwmchip0/pwm1/duty_cycle"); /*设置pwm1的占空比,单位是ns*/
	system("echo normal > /sys/class/pwm/pwmchip0/pwm1/polarity");	 /*设置pwm1的极性：normal 正极性，inverse 负极性*/
	system("echo 0 > /sys/class/pwm/pwmchip0/pwm1/enable");			 /*使能pwm1,1 使能，0 禁用*/
	return;
}
void pwmLv1(void)
{
	// printf("c-pwm:lv1 on\n");
	system("echo 500000 > /sys/class/pwm/pwmchip0/pwm1/period");	 /*设置pwm1的周期，单位是ns*/
	system("echo 200000 > /sys/class/pwm/pwmchip0/pwm1/duty_cycle"); /*设置pwm1的占空比,单位是ns*/
	return;
}
void pwmLv2(void)
{
	// printf("c-pwm:lv2 on\n");
	system("echo 500000 > /sys/class/pwm/pwmchip0/pwm1/period");	 /*设置pwm2的周期，单位是ns*/
	system("echo 300000 > /sys/class/pwm/pwmchip0/pwm1/duty_cycle"); /*设置pwm2的占空比,单位是ns*/
	return;
}
void pwmLv3(void)
{
	// printf("c-pwm:lv3 on\n");
	system("echo 1 > /sys/class/pwm/pwmchip0/export");				 /*启动pwm3功能位*/
	system("echo 600000 > /sys/class/pwm/pwmchip0/pwm1/period");	 /*设置pwm3的周期，单位是ns*/
	system("echo 200000 > /sys/class/pwm/pwmchip0/pwm1/duty_cycle"); /*设置pwm3的占空比,单位是ns*/
	return;
}
void pwmLv4(void)
{
	// printf("c-pwm:lv4 on\n");
	system("echo 1 > /sys/class/pwm/pwmchip0/export");				 /*启动pwm4功能位*/
	system("echo 600000 > /sys/class/pwm/pwmchip0/pwm1/period");	 /*设置pwm4的周期，单位是ns*/
	system("echo 300000 > /sys/class/pwm/pwmchip0/pwm1/duty_cycle"); /*设置pwm4的占空比,单位是ns*/
	return;
}
void pwmLv5(void)
{
	// printf("c-pwm:lv5 on\n");
	system("echo 1 > /sys/class/pwm/pwmchip0/export");				 /*启动pwm5功能位*/
	system("echo 600000 > /sys/class/pwm/pwmchip0/pwm1/period");	 /*设置pwm5的周期，单位是ns*/
	system("echo 400000 > /sys/class/pwm/pwmchip0/pwm1/duty_cycle"); /*设置pwm5的占空比,单位是ns*/
	return;
}
void pwmLv6(void)
{
	// printf("c-pwm:lv6 on\n");
	system("echo 1 > /sys/class/pwm/pwmchip0/export");				 /*启动pwm6功能位*/
	system("echo 700000 > /sys/class/pwm/pwmchip0/pwm1/period");	 /*设置pwm6的周期，单位是ns*/
	system("echo 400000 > /sys/class/pwm/pwmchip0/pwm1/duty_cycle"); /*设置pwm6的占空比,单位是ns*/
	return;
}
void pwmOff(void)
{
	// printf("c-pwm:off\n");
	system("echo 0 > /sys/class/pwm/pwmchip0/pwm1/enable"); /*使能pwm1,1 使能，0 禁用*/
	return;
}

void pwmOn(void)
{
	// printf("c-pwm:off\n");
	system("echo 1 > /sys/class/pwm/pwmchip0/pwm1/enable"); /*使能pwm1,1 使能，0 禁用*/
	return;
}
