var dlfcn = require("dlfcna.js");
//console.log(dlfcn);

var funcs = [["generate_md5_for_directory", "vss"]];

//console.log("in factory_egenmd5.js");
function register() {
  //console.log("will register saveData process.platform=" + process.platform)
  if (process.platform == "win32") {
      //console.log("***will register win32_register_func*****")
      const Win32RegFunc = require("win32_register_func.js").Win32RegFunc;
      var win32Reg = new Win32RegFunc(funcs);
      return win32Reg;
  }
  //console.log("will register egenmd5.so");
  var isSuccess = dlfcn.register(
    "@native.egenmd5",
    "./lib/factory/egenmd5.so",
    funcs
  );
  if (isSuccess) {
    //console.log("load so successfully");
    var egenmd5 = require("@native.egenmd5");
    return egenmd5;
  } else {
    //console.log("load so failed");
  }
  return undefined;
}
var egenmd5 = register();

function update(filepath,md5path) {
  egenmd5.generate_md5_for_directory(filepath,md5path);
}
module.exports = {
  update: update,
};
