

var systemCtrl = require("systemCtrl.js");
const fs = require("@system.fs")
var _userdata = require("userdata.js");
var userData = _userdata.userData;
var handleSNDataBinFile = require("handleSNDataBinFile.js");
var router = require("@system.router");
var bglight = require("bglight.js");
var envTemp = require("environmentTemperature.js");
var resultsWifiList = [];
var SECURE_APP_PATH = "/mnt/app/eOpteeCtrl"
var that;
var scanFlag = true;
var idScanTimerOut = null;
var fullLic;
function parseWifiScanResults(output) {
    const results = [];
    /* 去掉文件头两行 */
    const lines = output.split('\n').slice(2);

    lines.forEach((raw, idx) => {
        const l = raw.trim();
        if (!l) return;

        /* 原始行：02:b1:f7:70:1d:a2  2412  -37  [WPA2-PSK-CCMP][ESS]  Waterworld-A8 */
        const cols = l.split(/\t|\s{2,}/);   // 按 Tab 或两个以上空格切
        if (cols.length < 5) return;

        const mac = cols[0];                // bssid
        const rssi = parseInt(cols[2], 10);  // signal level
        const ssid = cols.slice(4).join(' ').trim(); // ssid 可能带空格

        /* 拼成目标格式：01,name:xxx,rssi:-50,mac:xx-xx-xx-xx-xx-xx */
        results.push({
            idx: String(idx + 1).padStart(2, '0'), // 01 02 03 ...
            name: ssid || '',
            rssi: rssi,
            mac: mac.split(':').join('-')          // 统一成横杠
        });
    });
    return results;
}

function checkUsbDeviceExist() {
    // /sys/devices/platform/soc@3000000/4200000.ehci1-controller/usb1/1-1doOtg 
    var usbPath = "/sys/devices/platform/soc@3000000/4200000.ehci1-controller/usb1/1-1"
    var ret = devExist(usbPath);
    // console.log("checkUsbDeviceExist ret: " + ret)
    if (devExist(usbPath)) return true
    return false;
}

function enableScan() {
    console.log("!!!!!!!!!!!!Is @@@@@@@@@@@@@@@@@@@@@@@@@@#enableScan")

    var process = require("@system.process")
    if (process.platform == "win32") {
        console.log("its win32.")
        return;
    }
    // console.log("resultsWifiList:")
    // if (resultsWifiList && oneFlag) {
    //     scanRefreshWifiList(resultsWifiList)
    //     oneFlag = 0;
    // }
    if (scanFlag == false) {
        return;
    }
    system("rm -fr /tmp/scan_FactoryResult.txt")
    system("wpa_cli -p /tmp/wpa_supplicant/sockets scan")

    scanFlag = false;
    if (idScanTimerOut != null) {
        clearTimeout(idScanTimerOut);
        idScanTimerOut = null;
    }
    idScanTimerOut = setTimeout(function () {

        system("wpa_cli -p /tmp/wpa_supplicant/sockets scan_results > /tmp/scan_FactoryResult.txt")
        var content = fs.read("/tmp/scan_FactoryResult.txt", "r")
        if (content) {
            // console.log("content: " + content)
            var listScanValue = parseWifiScanResults(content)
            // console.log("listScanValue------------" + JSON.stringify(listScanValue))
            if (listScanValue.length > 0) {
                resultsWifiList = listScanValue;
                // console.log("!!scan"+JSON.stringify(resultsWifiList))
            }
        }
        scanFlag = true;
    }, 5000)
}


function startWifiScan() {

    enableScan()

}

var checkSsidName = "null"


function setSsid(value) {
    checkSsidName = value
}
function getssid() {
    return checkSsidName;
}
function AnalyzeATSearchSsid(value) {
    if (!value) return '';
    // 1. 只取第一行
    const firstLine = value.split(/[\r\n]/)[0];
    // 2. 去掉首尾不可见字符
    const line = firstLine.replace(/[^\x20-\x7E]/g, '').trim();
    const prefix = 'AT+DUT_START=';
    const idx = line.indexOf(prefix);
    if (idx === -1) return '';
    return line.slice(idx + prefix.length).trim();
}
function getWifiScan(value) {
    if (!Array.isArray(resultsWifiList) || resultsWifiList.length < 1)
        return "FAIL";
    var result = JSON.stringify(resultsWifiList);
    console.log("getWifiScan" + result)
    console.log("value:" + value)
    var ssid = AnalyzeATSearchSsid(value);
    console.log("check ssid :" + ssid + "------")
    var found = resultsWifiList.find(ap => ap.name == ssid);
    if (found) {
        return `name:${found.name},rssi:${found.rssi},mac:${found.mac}`;
    }
    else {
        return "FAIL";
    }
}
function writeSn(sn) {
    userData.aboutSNValue = sn;
    handleSNDataBinFile.writeSNDataToBinFile(userData.aboutSNValue);
}
function getSn() {
    return userData.aboutSNValue;
}
function getCrc() {
    system(SECURE_APP_PATH + " -l > /tmp/crc.txt");
    const txt = fs.read("/tmp/crc.txt", "r");
    if (!txt) return "NA";
    // 全局替换所有空白、冒号、回车、换行为空串
    return txt.replace(/[\s:\r\n]+/g, '');
}


function setBright(vlaue) {
    var valueB = Math.round(vlaue * 255 / 100);
    bglight.ctrl(valueB);
}

function getRtcTimer() {
    var partFilePath = "../../../../../dev/rtc1";
    if (!fs.exists(partFilePath)) {
        return "NA";
    }
    system('hwclock -f /dev/rtc1 > /tmp/hwRtc.txt');
    const raw = fs.read('/tmp/hwRtc.txt');
    if (!raw) return 'NA';

    /* 典型行：Thu Jan  1 18:22:21 1970  0.000000 seconds
       只处理前 4 段：星期 月 日 时间 年 */
    var p = 0;
    while (p < raw.length && raw[p] != ' ') p++;        // 跳过星期
    while (p < raw.length && raw[p] == ' ') p++;

    var monSt = p;
    while (p < raw.length && raw[p] != ' ') p++;        // 月份
    var mon = raw.slice(monSt, p);
    while (p < raw.length && raw[p] == ' ') p++;

    var daySt = p;
    while (p < raw.length && raw[p] != ' ') p++;        // 日
    var day = raw.slice(daySt, p);
    while (p < raw.length && raw[p] == ' ') p++;

    var timeSt = p;
    while (p < raw.length && raw[p] != ' ') p++;        // 时间 HH:MM:SS
    var time = raw.slice(timeSt, p);
    while (p < raw.length && raw[p] == ' ') p++;

    var yearSt = p;
    while (p < raw.length && raw[p] != ' ') p++;        // 年
    var year = raw.slice(yearSt, p);

    /* 月份英文→数字 */
    var monTbl = ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun',
        'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec'];
    var mo = 1;
    for (var i = 0; i < 12; i++) {
        if (mon === monTbl[i]) { mo = i + 1; break; }
    }

    /* 去掉前导空格并拼成目标格式 */
    day = day.trim();
    return year + '-' + mo + '-' + day + ' ' + time;
}


// value ==  1,2,3
function ciclkAutoFactory(value) {
    var arr = [0, 50, 100]
    setBright(arr[value - 1])
    console.log("!!ciclkAutoFactory:" + arr[value - 1])
}

function getTemp() {
    return envTemp.getTemper();
}
function getHumid() {
    return envTemp.getHumid();
}

function getTempHum() {
    return getTemp() + "," + getHumid();
}

function writeLic(lic) {
    handleSNDataBinFile.writeLicenseToBinFile(lic)
    handleSNDataBinFile.writeSNDataToBinFile(lic)
    handleSNDataBinFile.writeInnerSNDataToBinFile(lic)
}

/**
 * 将十六进制字符串按每 2 字符插入一个空格
 * @param {string} hexStr - 仅含 0-9A-Fa-f 的十六进制字符串
 * @returns {string}      - 带空格的格式，例如 "41 54 2B ..."
 */
function formatHexWithSpace(hexStr) {
    // 去除可能存在的 0x 前缀、空白及非法字符
    const clean = hexStr.replace(/^(0x)?/i, '').replace(/\s+/g, '').toUpperCase();
    // 按 2 字符切割后拼接
    return clean.match(/.{1,2}/g)?.join(' ') || '';
}

var autoMode = "";
function getAutoStartMode() {
    console.log("getAutoStartMode")
    return autoMode
}

function initUI() {
    initUI._isInit = false;
    if (initUI._isInit == false) {
        setAutoModeUI("INIT");
        initUI._isInit = true;
    }

}


function initPage(id) {
    that = id;
}
function ledTimerOut() {
    that.clearTimer()
    that.resetUI();
}
function setAutoModeUI(mode) {
    console.log("!!that:" + that)
    console.log("!!setAutoModeUI: " + mode)
    switch (mode) {
        case "LCD":
            that.ledtimerSet()
            // that.$hide("id_yes")
            // that.$hide("id_ng")
            // that.$hide("id_back")
            that.showButtonUI("hide");
            break;
        case "TOUCH":
            console.log("111")
            that.exitLedTest();
            that.onshwKeyBuntton();
            that.showButtonUI("show");
            break;
        case "INIT":
            autoMode = mode;
            router.push({
                path: "factory_autoFactory"
            });
            break;
        default:

            break;
    }

}

function exitAutoFactoryPage() {
    // router.push({
    //     path: "getStart"
    // });
    system("reboot 1")
}


// 41542B57524954455F4C49433D32312F333232298B6D8E21B368DBD9FE04DADE18BE74CF0BF181510CE7A3AE5C059A7FA2F990DF6DD94932D5C269EFD96337776AF6088DAC20D5F4F3E57A521803F3F0B9EC0D0D0A0A
// formatHexWithSpace  -- 41 54 2B 57 52 49 54 45 5F 4C 49 43 3D 32 31 2F 33 32 32 29 8B 6D 8E 21 B3 68 DB D9 FE 04 DA DE 18 BE 74 CF 0B F1 81 51 0C E7 A3 AE 5C 05 9A 7F A2 F9 90 DF 6D D9 49 32 D5 C2 69 EF D9 63 37 77 6A F6 08 8D AC 20 D5 F4 F3 E5 7A 52 18 03 F3 F0 B9 EC 0D 0D 0A 0A
//      41542B57524954455F4C49433D header
// 41542B57524954455F4C49433D 332F3332 //332F3332 // 2F后面为总段(固定32段)，前面为当前段   //3332 - 为总段
// 1、分割字符串 模糊匹配57524954455F4C4943 分割3D后面的字符串
// 2、获取段数和总段 如332F3332 在F3332前面的字符串在进行分割 得到数据段32298B6D8E21B368DBD9FE04DADE18BE74CF0BF181510CE7A3AE5C059A7FA2F990DF6DD94932D5C269EFD96337776AF6088DAC20D5F4F3E57A521803F3F0B9EC0D0D0A0A
// 3、删除结尾0D0D0A0A 得到完整数据段
// 4、使用formatHexWithSpace函数转换为16进制格式字符串(放在前面执行)
// 5、将当前段数存储到对应的数组中
// 6、当段数等于总段时候将数组所有数据拼接成字符串
// 7、将数据通过参数方式传入autoUtil.writeLic(lic);
function hexToAscii(hexStr) {
    let result = '';
    for (let i = 0; i < hexStr.length; i += 2) {
        const byte = hexStr.substr(i, 2);
        const charCode = parseInt(byte, 16);
        result += String.fromCharCode(charCode);
    }
    return result;
}
/* ========== 全局 ========== */

const licSegArray = [];             // 下标 = 段号-1


function licParce(recvBuf) {
    var comallArrLicVal = '4954455F4C4943';
    var allArrLicVal = '3332';          // 外部可改，总段号（16 进制字符串）
    var equal = '3D';
    // console.log('licParce recv:' + recvBuf);
    var buf = recvBuf;
    var titleBuf = recvBuf;

    /* 1. 以 comallArrLicVal 为分隔符劈成两段 */
    const pos = buf.indexOf(comallArrLicVal);
    // console.log("pos:" + pos)
    if (pos === -1) return -1;
    let core = buf.slice(pos + comallArrLicVal.length + 12);   // 后半段

    // console.log("!!!!1_   core:" + core)

    // console.log("1--core:" + core);
    /* 2. 去尾 D0D0A0A */
    // if (core.endsWith('D0D0A0A')) 
    core = core.slice(0, -8);
    console.log("recv:" + core);

    const expectedHexLen = 128; // 64 字节 = 128 个十六进制字符
    if (core.length !== expectedHexLen) {
        console.log(`长度错误：期望 ${expectedHexLen}，实际 ${core.length}`);
        return -2;
    } else {
        console.log(`长度正确：期望 ${expectedHexLen}，实际 ${core.length}`);
    }


    const posT = titleBuf.indexOf(equal);
    let coreT = titleBuf.slice(posT + equal.length);
    // console.log("coreT:" + coreT);
    const slashPos = coreT.indexOf('2F');
    if (slashPos === -1) { return -1; }
    const segHex = coreT.slice(0, slashPos);   // 例如 "31"

    // Hex 字符串当成 ASCII 解码
    // Hex → 字节 → ASCII → 数字
    // const segChar = String.fromCharCode(parseInt(segHex, 16)); // '1'
    const curSeg = hexToAscii(segHex);
    const totSeg = hexToAscii(allArrLicVal);
    console.log("recv index:" + curSeg);
    console.log("all index:" + totSeg);

    /* 4. 格式化并缓存 */
    // const spaced = formatHexWithSpace(core);
    const spaced = core;



    licSegArray[curSeg - 1] = spaced;


    console.log(`seg=${curSeg}/${totSeg} data=${spaced}`);

    // /* 5. 末段到齐 → 拼接写入 */
    if (curSeg === totSeg && licSegArray.every(v => v)) {
        fullLic = licSegArray.join('').replace(/\s+/g, '');
        // const fullLic = licSegArray.join('').replace(/\s+/g, '');
        writeLic(fullLic);
        console.log('Full license written:' + fullLic);
        licSegArray.length = 0;
    }
    return 1;
}

function testLicParce() {
    //     var fullLic = "202C3AE80810DA0000000000000000005F93DC7F18DDC42C761F2EADA48223F1D966861A2AC39B28F7C267BB282775556A57312196FC891E77BC3423E9685DD3CBE6DE5637B4D4BA26994AE0C94B103E3CE725C09825E2BCF2D0FBF5A\
    // 4A72250EA508EA8CA3450BB82EA7972C3B621134714E7485299C095D05AB13BC8A9A8BC952AFBD0F003F72C29C5B6B3EC95EC12D3EA67CDDF0CA5324AC7C15A69D0D72B0F7951FDB05D6D6C5196AD1FD27074D08E13A5088B8B2C8C65A5EB21AE379E313F78E15\
    // 6ACB89E4216AAAB3C2374CCF9BD64829FB55C83E98883FC385B34AEBD2C39BE5AE52A7EA41F1DA928859CE10BA28C6F42073792CD083D060DF501677D818ED55AF9CCCBFE7F0B8DD58C720F52A08B53049E9C0B88CD85BB4BC8D389C635F3A7815D38CF8A4DAA3\
    // E75D27A45CD7F677728E86E8FA02392A9245CBE0C723D6C400483244A2AA3C78FD27692833BF6B4FCE9CF469DAF22A4AFEFAC0F1E04AC8A7A35931DC5A253A3BC35677F561CA128A28B5A3C2F76D6B283A84A14F60AB1B905CBDB9CDA45B585ECDE579834D8540\
    // 2EEA279CBB75F4A7585AF311EE856A41E4A1174C0A9835C24B8AD55EE94E1F51F25E03AB3AE4DEC4153909F30D4A263961275F82C7599128450C3937068BCF2D8A6217DC7ED515AFB8FA5D19A4C7E97D7D43A54D128CBFE49AA5A06B189D59BB3AEC89525C4C3E\
    // 09244CD6E8D8F94A055E00C16B6A3AFEF08860ECD9F83FC6D9549DBE54D8C0703C5052741C4C8791CD0B3CCB7C01F0114F340DC5778B6659515E8117A3720336DB4C8AD9388937107925BE11D69C0052EE614B989450E8E59108483E1AFFEA3004D05E13F27DBE\
    // 37D31B2DC6F5D05A417E802D226F2A200021D906EFBE492E3507C22EF3C12427625E696847104EEAD6DBBC4256ABCA03C8A0330D23F9D412798F1AC7DAEA0DD4848C77EE97391CFD9C0DC6262DAE0CF09806CE17A17D8FB90AEA8FA1BFB9DE32ED05C1C3FB817E\
    // 657F320466748643E3A7B5748982F080EF83B9E61063F4A7AA65BC16CA3A0713FF4C522F8C5CF5044B5074FFA9D0901837B83FEFE6C4E101EB4B8BED41B078F044071FCE51798B41905AA5A8C7AD83110F57303B9CE9685FB507F8912A12576968138B3C2191A9\
    // E23BE7F7EB74E40EFAEDD84891C9990F44D1003B9AD75462DB7E1388097D36BC7460BAF70FAA748A68BFBB6DB4062504548F99703A7BD0220582A54913A9556DF9E75B5B49FC2A6868A05FC0FD9E9A6AFE11E2FA6BE61B63ECA9B824F5FEFAED65EE6E717DF77F\
    // 0AA7EA169BC592DFE9B259F631BDF500913675EC3B6C9EC590713E55FFDFC0755D59BF061E24DA89EA57043BF7C336A0C6194BF9858D7384E68B90E3FE6977E873FA274FE087079D33003537B5748982F080EF83B9E61063F4A7AA675D0DB5DFCC4FE811ED5783\
    // B7224413642146428096DA280CEA85F5378279C3F5794DCCFA3579127BF0BD098B127099889F0170E39920C1B19C9042BB28ECD2C656FF58FA4C48A7DC463F04E4AFE977096E6B7BF282B5545D54090A7E3C1BF49B154DD733C2617A33AB7CE39446C398E0A6F9\
    // 0EA70526A299B8FEBFFCEB3A791FEA790CAA610E878DFE6540F6909B9C07DDB22072BA29F88462049F4EB6337764CCA84ADE9F9C07FE097C27E15B5D35BA03F9EC1829C73ED33C2297915EC047BE6E617A5B251BF0B79206FE7BDF694AAE408DC705DB7918081E\
    // E71EBC5276B22B6F817AC47DC8D44EC363A849CA57BA736AA18A5110FE6BC60490165B17A7CDA7B5748982F080EF83B9E61063F4A7AA632298B6D8E21B368DBD9FE04DADE18BE74CF0BF181510CE7A3AE5C059A7FA2F990DF6DD94932D5C269EFD96337776AF60\
    // 88DAC20D5F4F3E57A521803F3F0B9EC740B79EAF795A3A44F54F9528DF80B7B10C80830C248C0DA0A0390C8A413A3C38BB7CF499B93B2E3787AAEB70276EB6B87255B8CA730F64EABD9D908422C10762AD22E0B869BDA06198E50F5B21A7D8F002A38537B03D45\
    // FCADD5DC61AC5BD01FD29A924C67B38C32DDA61EB15CD5542C6E44790CD77A1ACF499855426A086F464767F0E366FD4C952A0C5532A3E2481FF9097C1674B49F3BEE0B290E321AE8EFF623D08E8413FF0866B6785DFCD770886DBB220648812D5330788301F8AF\
    // 3F07B5748982F080EF83B9E61063F4A7AA6720A13ECEF43B746BDE51C48F760503D7A9399EF5DD8F5FA7F09321BBAA0945B233C6469B520F357A6C9DDA6BCCE46CC958178FCD173DB951D15559F1147BB40897A06C2B27D7EEC04AAF191A38B297AF5CEE70BCB0\
    // CBF6AE6139BF31F619FBB67B7381761C6B45ED8CA07B43DB8A72D7F1F8E94ECA1916249B4D0338BC1BB17627FBC2DAAD8145329492721B8698475415278BA579696419F378CB387A811D2B8E678A7E5154DD5692D61632ABB7A51B5F03BCB17B9A971C39E1C2C9\
    // 2266F8433901D31261F04FB8C6C3EAF59BCAB4022079AA2A651C95199371A3465A5E98F052B959D669B89C114A3BDD69E973598FF907C495ABFFD326BB66A6503F697245F93DC7F18DDC42C761F2EADA48223F1D966861A2AC39B28F7C267BB28277555C80FC78\
    // 8423B3E667442E56A6AEA5D4CD0707E03103DF2AF339F2AD67F4AAEBF00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000\
    // 0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000BBE7700481CE78FC040BB1DDE4D8FE55985227C9A42401FA7D33DD09E5CD83A4"

    if (!fullLic || fullLic == undefined) {
        console.log("fullLic error")
        return "null";
    }
    // console
    const cksum = figureChecksum(fullLic, 2048);
    // console.log('checksum = 0x' + cksum.toString(16).padStart(2, '0'));
    return "0X" + cksum.toString(16).padStart(2, '0').toUpperCase();
}

/**
 * 累加和校验（8 位无符号）
 * @param {String} hexStr  连续 HEX 字符串，不限长度
 * @param {Number} size    要校验的字节数（<= 字节长度）
 * @returns {Number}       0-255 的校验和
 */
function figureChecksum(hexStr, size = 2048) {
    const bytes = hexStr.match(/.{2}/g).map(b => parseInt(b, 16));
    const len = Math.min(size, bytes.length);
    let checksum = 0;
    for (let i = 0; i < len; i++) {
        checksum = (checksum + bytes[i]) & 0xFF;   // 强制 8 位
    }
    return checksum;
}

function initUartPWM() {
    system("/mnt/app/quicknode/shell/uartPwmInit.sh &");
}


function hexStringToBytes(hexStr) {
    const bytes = new Uint8Array(hexStr.length / 2);
    for (let i = 0; i < bytes.length; i++) {
        bytes[i] = parseInt(hexStr.substr(i * 2, 2), 16);
    }
    return bytes;
}


// 入参：设备路径  返回：1 存在，0 不存在
function devExist(devPath) {
    const tmpFlag = "/tmp/dev_exist.flag";
    system(
        `[ -e '${devPath}' ] && echo 1 > ${tmpFlag} || echo 0 > ${tmpFlag}`
    );
    const ret = fs.read(tmpFlag, "r");
    return (ret && ret.trim() === "1") ? 1 : 0;
}
function initautoFactorySetting() {
    require("autoOffScreen.js").onOffAtuoOffScreen();
    // setBright(100)
    var soundLevelText = "tinymix set 16 7"
    system(soundLevelText);
}

function system(cmd) {
    systemCtrl.executeSystemCommand(cmd)
}



module.exports = {
    startWifiScan: startWifiScan,
    getWifiScan: getWifiScan,
    writeSn: writeSn,
    getSn: getSn,
    getCrc: getCrc,
    getAutoStartMode: getAutoStartMode,
    setBright: setBright,
    ciclkAutoFactory: ciclkAutoFactory,
    getTempHum: getTempHum,
    writeLic: writeLic,
    formatHexWithSpace: formatHexWithSpace,
    initPage: initPage,
    setAutoModeUI: setAutoModeUI,
    initUI: initUI,
    ledTimerOut: ledTimerOut,
    exitAutoFactoryPage: exitAutoFactoryPage,
    licParce: licParce,
    figureChecksum: figureChecksum,
    testLicParce: testLicParce,
    initUartPWM: initUartPWM,
    devExist: devExist,
    checkUsbDeviceExist: checkUsbDeviceExist,
    getRtcTimer: getRtcTimer,
    setSsid: setSsid,
    getssid: getssid,
    initautoFactorySetting: initautoFactorySetting
}
