var dlfcn = require("dlfcna.js");
console.log(dlfcn)
var funcs = [
    ["uart_init", "iss"],
    ["uart_close", "vi"],
    ["uart_send", "iisi"],
    ["uart_recv", "si"],
    ["uart_recv_hex", "si"],
    ["kill_tty_user", "is"],
    ["pwm_uart_init", "vv"],
    ["uart_set_canonical", "vi"],
    ["uart_set_raw", "vi"]


];
console.log("in uartUtil.js")
function register() {

    console.log("will register uartUtil.so")
    var isSuccess = dlfcn.register("@native.uartUtil", "/mnt/app/quicknode/tests/re860_factory/lib/factory/uartUtil.so", funcs);
    if (isSuccess) {
        console.log("load so successfully")
        var uartUtil = require("@native.uartUtil");
        return uartUtil
    } else {
        console.log("load so failed")
    }
    return undefined;
}
var uartUtil = register();

function uart_init(port, baud_str) {
    // int uart_init(const char *port, const char *baud_str);
    return uartUtil.uart_init(port, baud_str);
}
function uart_close(fd) {
    // void uart_close(int fd);
    uartUtil.uart_close(fd);
}
function uart_send(fd, data, len) {
    // int uart_send(int fd, const void *data, size_t len);
    return uartUtil.uart_send(fd, data, len);
}
function uart_recv(fd) {
    // char *uart_recv(int fd)
    return uartUtil.uart_recv(fd);
}
function uart_recv_hex(fd) {
    console.log("!!uart_recv_hex:" + fd);
    // char *uart_recv(int fd)
    // console.log("uart_recv_hex:" + fd);
    return uartUtil.uart_recv_hex(fd);
}

function kill_tty_user(port) {
    console.log("!!kill_tty_user:" + port);
    // const char *port = "/dev/ttyS0";
    // int killed = kill_tty_user(port);
    return uartUtil.kill_tty_user(port);
}
function pwm_uart_init() {
    console.log("!!pwm_uart_init");
    uartUtil.pwm_uart_init();
}
function uart_set_canonical(fd) {
    console.log("!!!!!!    Please use C code to modify rx_thread  !!!!!");
    return;
    console.log("!!uart_set_canonical:" + fd);
    // 串口设为 canonical 模式 //
    uartUtil.uart_set_canonical(fd);
}
function uart_set_raw(fd) {
    console.log("!!uart_set_raw:" + fd);
    // 串口设为 raw 模式
    uartUtil.uart_set_raw(fd);
}



module.exports = {
    uart_init: uart_init,
    uart_close: uart_close,
    uart_send: uart_send,
    uart_recv: uart_recv,
    uart_recv_hex: uart_recv_hex,
    kill_tty_user: kill_tty_user,
    pwm_uart_init: pwm_uart_init,
    uart_set_canonical: uart_set_canonical,
    uart_set_raw: uart_set_raw

}
