
var _userdata = require("userdata.js");
var userData = _userdata.userData;
const fs = require("@system.fs");
var systemCtrl = require("systemCtrl.js");
var lvgl = require("@native.lvgl7");
var id_testRtcTimer = null;
var that;
var rtcCtl = require("factory_rtc.js");


function system(str) {
    systemCtrl.executeSystemCommand(str);
}


function exitTestRTC(){
      if (id_testRtcTimer != null) {
        clearInterval(id_testRtcTimer);
        id_testRtcTimer == null;
    }
}

function factoryTestRTCInit(obj) {
    that = obj;
    if (id_testRtcTimer != null) {
        clearInterval(id_testRtcTimer);
        id_testRtcTimer == null;
    }
    updateRtcInfo();
    id_testRtcTimer = setInterval(() => {
        updateRtcInfo();
    }, 5000);
}
function setTextColorById(that, id, value) {
    const color = (value === "NA") ? "#ff0000" : "#00ff00";
    that.$setTextColor(id, color);
}


function updateRtcInfo() {
    var rtc = getRtcTime();
    that.crtLocalTime = rtc;
    //console.log("hwRtc:" + rtc);



    setTextColorById(that, 'id_crtLocalTime', that.crtLocalTime);

    var values = [that.crtLocalTime];
    var allValuesValid = values.every(value => value !== "NA");
    // 根据检查结果设置烧录测试状态
    globalThis.factoryTest.rtc = allValuesValid ? 1 : 2;

    var Yval = allValuesValid == 1 ? 0 : -480
    that.$setY("id_yes",Yval)


}


function getRtcTime() {
    system("hwclock > /tmp/hwRtc.txt");
    const coresStr = fs.read("/tmp/hwRtc.txt", "r");
    if (coresStr) {
        return coresStr.split('\n');
    } else {
        // system("killall -9 /dev/rtc0");
        return "NA";
    }
}




module.exports = {
    factoryTestRTCInit: factoryTestRTCInit,
    exitTestRTC: exitTestRTC


}