var dlfcn = require("dlfcna.js");
//console.log(dlfcn)

var funcs = [
    ["get_modem_signal", "ss"],
    ["get_modem_iccid", "ss"],
    ["get_modem_imei", "ss"],
];

//console.log("in factory_esim.js")
function register() {
    //console.log("will register test_modem.so")
    var isSuccess = dlfcn.register("@native.test_modem", "./lib/factory/test_modem.so", funcs);
    if (isSuccess) {
        //console.log("load so successfully")
        var test_modem = require("@native.test_modem");
        return test_modem
    } else {
        //console.log("load so failed")
    }
    return undefined;
}
var test_modem = register();


function read(option) {
    var value;
    switch (option) {

        case "signal":
            try {
                value = test_modem.get_modem_signal();
            } catch (e) {
                value = undefined
                //console.log("!!!ERROR:" + e)
            }
            break;
        case "iccid":
            try {
                value = test_modem.get_modem_iccid();
            } catch (e) {
                value = undefined
                //console.log("!!!ERROR:" + e)
            }
            break;
        case "imei":
            try {
                value = test_modem.get_modem_imei();
            } catch (e) {
                value = undefined
                //console.log("!!!ERROR:" + e)
            }
            break;
        default:
            break;
    }
    //console.log("....");
    //console.log("============" + "read" + option + "/// value:" + value + "============");
    //console.log("....");
    return value;

}

module.exports = {

    read: read,
}
