

var systemCtrl = require("systemCtrl.js");
const fs = require("@system.fs")
var _userdata = require("userdata.js");
var userData = _userdata.userData;
var handleSNDataBinFile = require("handleSNDataBinFile.js");
var router = require("@system.router");
var bglight = require("bglight.js");
var envTemp = require("environmentTemperature.js");
var uart = require("factory_uartUtil.js");
var resultsWifiList = [];
var SECURE_APP_PATH = "/mnt/app/eOpteeCtrl"
var that;
var scanFlag = true;
var idScanTimerOut = null;
var fullLic;
function parseWifiScanResults(output) {
    const results = [];
    /* 去掉文件头两行 */
    const lines = output.split('\n').slice(2);

    lines.forEach((raw, idx) => {
        const l = raw.trim();
        if (!l) return;

        /* 原始行：02:b1:f7:70:1d:a2  2412  -37  [WPA2-PSK-CCMP][ESS]  Waterworld-A8 */
        const cols = l.split(/\t|\s{2,}/);   // 按 Tab 或两个以上空格切
        if (cols.length < 5) return;

        const mac = cols[0];                // bssid
        const rssi = parseInt(cols[2], 10);  // signal level
        const ssid = cols.slice(4).join(' ').trim(); // ssid 可能带空格

        /* 拼成目标格式：01,name:xxx,rssi:-50,mac:xx-xx-xx-xx-xx-xx */
        results.push({
            idx: String(idx + 1).padStart(2, '0'), // 01 02 03 ...
            name: ssid || '',
            rssi: rssi,
            mac: mac.split(':').join('-')          // 统一成横杠
        });
    });
    return results;
}

function checkUsbDeviceExist() {
    // /sys/devices/platform/soc@3000000/4200000.ehci1-controller/usb1/1-1doOtg 
    var usbPath = "/sys/devices/platform/soc@3000000/4200000.ehci1-controller/usb1/1-1"
    var ret = devExist(usbPath);
    // console.log("checkUsbDeviceExist ret: " + ret)
    if (devExist(usbPath)) return true
    return false;
}

function enableScan() {
    console.log("!!!!!!!!!!!!Is @@@@@@@@@@@@@@@@@@@@@@@@@@#enableScan")

    var process = require("@system.process")
    if (process.platform == "win32") {
        console.log("its win32.")
        return;
    }
    // console.log("resultsWifiList:")
    // if (resultsWifiList && oneFlag) {
    //     scanRefreshWifiList(resultsWifiList)
    //     oneFlag = 0;
    // }
    if (scanFlag == false) {
        return;
    }
    system("rm -fr /tmp/scan_FactoryResult.txt")
    system("wpa_cli -p /tmp/wpa_supplicant/sockets scan")

    scanFlag = false;
    if (idScanTimerOut != null) {
        clearTimeout(idScanTimerOut);
        idScanTimerOut = null;
    }
    idScanTimerOut = setTimeout(function () {

        system("wpa_cli -p /tmp/wpa_supplicant/sockets scan_results > /tmp/scan_FactoryResult.txt")
        var content = fs.read("/tmp/scan_FactoryResult.txt", "r")
        if (content) {
            // console.log("content: " + content)
            var listScanValue = parseWifiScanResults(content)
            // console.log("listScanValue------------" + JSON.stringify(listScanValue))
            if (listScanValue.length > 0) {
                resultsWifiList = listScanValue;
                // console.log("!!scan"+JSON.stringify(resultsWifiList))
            }
        }
        scanFlag = true;
    }, 5000)
}


function startWifiScan() {

    enableScan()

}

var checkSsidName = "null"


function setSsid(value) {
    checkSsidName = value
}
function getssid() {
    return checkSsidName;
}
function AnalyzeATSearchSsid(value) {
    if (!value) return '';
    // 1. 只取第一行
    const firstLine = value.split(/[\r\n]/)[0];
    // 2. 去掉首尾不可见字符
    const line = firstLine.replace(/[^\x20-\x7E]/g, '').trim();
    const prefix = 'AT+DUT_START=';
    const idx = line.indexOf(prefix);
    if (idx === -1) return '';
    return line.slice(idx + prefix.length).trim();
}
function getWifiScan(value) {
    if (!Array.isArray(resultsWifiList) || resultsWifiList.length < 1)
        return "FAIL";
    var result = JSON.stringify(resultsWifiList);
    console.log("getWifiScan" + result)
    console.log("value:" + value)
    var ssid = AnalyzeATSearchSsid(value);
    console.log("check ssid :" + ssid + "------")
    // var found = resultsWifiList.find(ap => ap.name == ssid);
    // if (found) {
    //     return `name:${found.name},rssi:${found.rssi},mac:${found.mac}`;
    // }
    // else {
    //     return "FAIL";
    // }
    var matchingAPs = resultsWifiList.filter(ap => ap.name === ssid);
    if (matchingAPs.length === 0) {
        return "FAIL";
    }
    console.log("matchingAPs :" + JSON.stringify(matchingAPs) + "------")
    var bestAP = matchingAPs.sort((a, b) => b.rssi - a.rssi)[0];

    return `name:${bestAP.name},rssi:${bestAP.rssi},mac:${bestAP.mac}`;
}
function writeSn(sn) {
    userData.aboutSNValue = sn;
    handleSNDataBinFile.writeSNDataToBinFile(userData.aboutSNValue);
}
function getSn() {
    return userData.aboutSNValue;
}
function getCrc() {
    system(SECURE_APP_PATH + " -l > /tmp/crc.txt");
    const txt = fs.read("/tmp/crc.txt", "r");
    if (!txt) return "NA";
    // 全局替换所有空白、冒号、回车、换行为空串
    return txt.replace(/[\s:\r\n]+/g, '');
}


function setBright(vlaue) {
    var valueB = Math.round(vlaue * 255 / 100);
    bglight.ctrl(valueB);
}

function getRtcTimer() {
    var partFilePath = "/dev/rtc1";
    if (!fs.exists("../../../../.." + partFilePath)) {
        return "FAIL";
    }
    var str = "hwclock -f " + partFilePath + " > /tmp/hwRtc.txt"
    system(str);
    const raw = fs.read('/tmp/hwRtc.txt');
    if (!raw) return 'FAIL';

    /* 典型行：Thu Jan  1 18:22:21 1970  0.000000 seconds
       只处理前 4 段：星期 月 日 时间 年 */
    var p = 0;
    while (p < raw.length && raw[p] != ' ') p++;        // 跳过星期
    while (p < raw.length && raw[p] == ' ') p++;

    var monSt = p;
    while (p < raw.length && raw[p] != ' ') p++;        // 月份
    var mon = raw.slice(monSt, p);
    while (p < raw.length && raw[p] == ' ') p++;

    var daySt = p;
    while (p < raw.length && raw[p] != ' ') p++;        // 日
    var day = raw.slice(daySt, p);
    while (p < raw.length && raw[p] == ' ') p++;

    var timeSt = p;
    while (p < raw.length && raw[p] != ' ') p++;        // 时间 HH:MM:SS
    var time = raw.slice(timeSt, p);
    while (p < raw.length && raw[p] == ' ') p++;

    var yearSt = p;
    while (p < raw.length && raw[p] != ' ') p++;        // 年
    var year = raw.slice(yearSt, p);

    /* 月份英文→数字 */
    var monTbl = ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun',
        'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec'];
    var mo = 1;
    for (var i = 0; i < 12; i++) {
        if (mon === monTbl[i]) { mo = i + 1; break; }
    }

    /* 去掉前导空格并拼成目标格式 */
    day = day.trim();
    return year + '-' + mo + '-' + day + ' ' + time;
}


// value ==  1,2,3
function ciclkAutoFactory(value) {
    var arr = [0, 50, 100]
    setBright(arr[value - 1])
    console.log("!!ciclkAutoFactory:" + arr[value - 1])
}

function getTemp() {
    return envTemp.getTemper();
}
function getHumid() {
    return envTemp.getHumid();
}

function getTempHum() {
    return getTemp() + "," + getHumid();
}

function writeLic(hexStr) {
    var filePath1 = "/tmp/operation_license";
    // var filePath2 = "/tmp/sn_data.bin";
    // const SECURE_APP_PATH = "/mnt/app/eOpteeCtrl"

    console.log('Full license written:' + hexStr);

    var hexLen = hexStr.length;
    var result = uart.writeData(hexStr, hexLen, filePath1);
    if (result == 1) {
        console.log("Data written successfully.");
    } else {
        console.log("Failed to write data.");
    }
    system("sync");
    system(SECURE_APP_PATH + " -b " + filePath1);

    // handleSNDataBinFile.writeInnerSNDataToBinFile(lic)
    system("cp /tmp/operation_license /mnt/userdataA/files/");
    system("/mnt/app/eMideaSetMac");
}

/**
 * 将十六进制字符串按每 2 字符插入一个空格
 * @param {string} hexStr - 仅含 0-9A-Fa-f 的十六进制字符串
 * @returns {string}      - 带空格的格式，例如 "41 54 2B ..."
 */
function formatHexWithSpace(hexStr) {
    // 去除可能存在的 0x 前缀、空白及非法字符
    const clean = hexStr.replace(/^(0x)?/i, '').replace(/\s+/g, '').toUpperCase();
    // 按 2 字符切割后拼接
    return clean.match(/.{1,2}/g)?.join(' ') || '';
}

var autoMode = "";
function getAutoStartMode() {
    console.log("getAutoStartMode")
    return autoMode
}

function initUI() {
    initUI._isInit = false;
    if (initUI._isInit == false) {
        setAutoModeUI("INIT");
        initUI._isInit = true;
    }

}


function initPage(id) {
    that = id;
}
function ledTimerOut() {
    that.clearTimer()
    that.resetUI();
}
function setAutoModeUI(mode) {
    console.log("!!that:" + that)
    console.log("!!setAutoModeUI: " + mode)
    switch (mode) {
        case "LCD":
            ciclkAutoFactory(3);
            that.ledtimerSet()
            // that.$hide("id_yes")
            // that.$hide("id_ng")
            // that.$hide("id_back")
            that.showButtonUI("hide");
            break;
        case "TOUCH":
            console.log("111")
            that.exitLedTest();
            that.onshwKeyBuntton();
            that.showButtonUI("show");
            break;
        case "INIT":
            autoMode = mode;
            router.push({
                path: "factory_autoFactory"
            });
            break;
        default:

            break;
    }

}

function exitAutoFactoryPage() {
    // router.push({
    //     path: "getStart"
    // });
    system("reboot 1")
}


// 41542B57524954455F4C49433D32312F333232298B6D8E21B368DBD9FE04DADE18BE74CF0BF181510CE7A3AE5C059A7FA2F990DF6DD94932D5C269EFD96337776AF6088DAC20D5F4F3E57A521803F3F0B9EC0D0D0A0A
// formatHexWithSpace  -- 41 54 2B 57 52 49 54 45 5F 4C 49 43 3D 32 31 2F 33 32 32 29 8B 6D 8E 21 B3 68 DB D9 FE 04 DA DE 18 BE 74 CF 0B F1 81 51 0C E7 A3 AE 5C 05 9A 7F A2 F9 90 DF 6D D9 49 32 D5 C2 69 EF D9 63 37 77 6A F6 08 8D AC 20 D5 F4 F3 E5 7A 52 18 03 F3 F0 B9 EC 0D 0D 0A 0A
//      41542B57524954455F4C49433D header
// 41542B57524954455F4C49433D 332F3332 //332F3332 // 2F后面为总段(固定32段)，前面为当前段   //3332 - 为总段
// 1、分割字符串 模糊匹配57524954455F4C4943 分割3D后面的字符串
// 2、获取段数和总段 如332F3332 在F3332前面的字符串在进行分割 得到数据段32298B6D8E21B368DBD9FE04DADE18BE74CF0BF181510CE7A3AE5C059A7FA2F990DF6DD94932D5C269EFD96337776AF6088DAC20D5F4F3E57A521803F3F0B9EC0D0D0A0A
// 3、删除结尾0D0D0A0A 得到完整数据段
// 4、使用formatHexWithSpace函数转换为16进制格式字符串(放在前面执行)
// 5、将当前段数存储到对应的数组中
// 6、当段数等于总段时候将数组所有数据拼接成字符串
// 7、将数据通过参数方式传入autoUtil.writeLic(lic);
function hexToAscii(hexStr) {
    let result = '';
    for (let i = 0; i < hexStr.length; i += 2) {
        const byte = hexStr.substr(i, 2);
        const charCode = parseInt(byte, 16);
        result += String.fromCharCode(charCode);
    }
    return result;
}
/* ========== 全局 ========== */

var licSegArray = [];             // 下标 = 段号-1
function getpectedHexLen(seg) {
    // 总长度数据4096
    console.log("seg: " + seg);
    var hexLen = 0;
    switch (seg) {
        case "32":
            hexLen = 128; // 64 字节 = 128 个十六进制字符
            break;
        case "16":
            hexLen = 256;
            break;
        case "08":
            hexLen = 512;
            break;
        case "04":
            hexLen = 1024;
            break;
        case "02":
            hexLen = 2048;
            break;
        default:
            hexLen = 128;
            break;
    }
    console.log("hexLen: " + hexLen);
    return hexLen;
}


function licParce(recvBuf) {
    var comallArrLicVal = '4954455F4C4943';
    // var allArrLicVal = '3332';          // 外部可改，总段号（16 进制字符串）
    var equal = '3D';
    // console.log('licParce recv:' + recvBuf);
    var buf = recvBuf;
    var titleBuf = recvBuf;

    /* 1. 以 comallArrLicVal 为分隔符劈成两段 */
    const pos = buf.indexOf(comallArrLicVal);
    // console.log("pos:" + pos)
    if (pos === -1) return 0;
    let core = buf.slice(pos + comallArrLicVal.length + 12);   // 后半段

    // console.log("!!!!1_   core:" + core)

    // console.log("1--core:" + core);
    /* 2. 去尾 D0D0A0A */
    // if (core.endsWith('D0D0A0A')) 
    core = core.slice(0, -8);
    console.log("recv:" + core);


    const posT = titleBuf.indexOf(equal);
    let coreT = titleBuf.slice(posT + equal.length);
    // console.log("coreT:" + coreT);
    const slashPos = coreT.indexOf('2F');
    if (slashPos === 1) { return 0; }
    const segHex = coreT.slice(0, slashPos);   // 例如 "31"
    const allArrLicVal = coreT.slice(slashPos + 2, slashPos + 6); // 总段数
    console.log("allArrLicVal:" + allArrLicVal);
    // Hex 字符串当成 ASCII 解码
    // Hex → 字节 → ASCII → 数字
    // const segChar = String.fromCharCode(parseInt(segHex, 16)); // '1'
    const curSeg = hexToAscii(segHex);
    const totSeg = hexToAscii(allArrLicVal);
    console.log("recv index:" + curSeg);
    console.log("all index:" + totSeg);

    //总长度数据4096
    var expectedHexLen = getpectedHexLen(totSeg);

    if (core.length !== expectedHexLen) {
        console.log(`长度错误：期望 ${expectedHexLen}，实际 ${core.length}`);
        return 2;
    } else {
        console.log(`长度正确：期望 ${expectedHexLen}，实际 ${core.length}`);
    }


    /* 4. 格式化并缓存 */
    // const spaced = formatHexWithSpace(core);
    const spaced = core;



    licSegArray[curSeg - 1] = spaced;


    console.log(`seg=${curSeg}/${totSeg} data=${spaced}`);
    if (curSeg === totSeg) {
        return 3;
    }
    return 1;
}

function gotoWriteLic() {
    console.log("--enter gotoWriteLic");
    // 确保 _timeOutId 是函数的静态属性
    if (gotoWriteLic._timeOutId == undefined) {
        gotoWriteLic._timeOutId = null;
    }

    // 清理之前的定时器
    if (gotoWriteLic._timeOutId) {
        clearTimeout(gotoWriteLic._timeOutId);
        gotoWriteLic._timeOutId = null;
    }

    // 设置新的定时器
    gotoWriteLic._timeOutId = setTimeout(() => {
        console.log("!!!!!!!!!!!!!!!!!!!!gotoWriteLic");
        // 检查 licSegArray 是否包含所有段的数据
        if (licSegArray.length > 0 && licSegArray.every(v => v)) {
            var recLic = licSegArray.join('').replace(/\s+/g, '');
            fullLic = recLic;

            // 写入许可证
            writeLic(fullLic);

            // 计算校验和
            var cksum = figureChecksum(recLic, 2048);
            console.log('checksum = ' + cksum);
            console.log("0X" + cksum.toString(16).padStart(2, '0').toUpperCase());

            // 清空 licSegArray
            licSegArray = [];
        } else {
            console.log("License segments are incomplete or invalid.");
        }
    }, 100);
}

function testLicParce() {

    if (!fullLic || fullLic == undefined) {
        console.log("fullLic error")
        return "null";
    }
    // console
    const cksum = figureChecksum(fullLic, 2048);
    fullLic = "";
    // console.log('checksum = 0x' + cksum.toString(16).padStart(2, '0'));
    return "0X" + cksum.toString(16).padStart(2, '0').toUpperCase();
}

/**
 * 累加和校验（8 位无符号）
 * @param {String} hexStr  连续 HEX 字符串，不限长度
 * @param {Number} size    要校验的字节数（<= 字节长度）
 * @returns {Number}       0-255 的校验和
 */
function figureChecksum(hexStr, size = 2048) {
    const bytes = hexStr.match(/.{2}/g).map(b => parseInt(b, 16));
    const len = Math.min(size, bytes.length);
    let checksum = 0;
    for (let i = 0; i < len; i++) {
        checksum = (checksum + bytes[i]) & 0xFF;   // 强制 8 位
    }
    return checksum;
}

function initUartPWM() {
    system("/mnt/app/quicknode/shell/uartPwmInit.sh &");
}


function hexStringToBytes(hexStr) {
    const bytes = new Uint8Array(hexStr.length / 2);
    for (let i = 0; i < bytes.length; i++) {
        bytes[i] = parseInt(hexStr.substr(i * 2, 2), 16);
    }
    return bytes;
}


// 入参：设备路径  返回：1 存在，0 不存在
function devExist(devPath) {
    const tmpFlag = "/tmp/dev_exist.flag";
    system(
        `[ -e '${devPath}' ] && echo 1 > ${tmpFlag} || echo 0 > ${tmpFlag}`
    );
    const ret = fs.read(tmpFlag, "r");
    return (ret && ret.trim() === "1") ? 1 : 0;
}
function initautoFactorySetting() {
    require("autoOffScreen.js").onOffAtuoOffScreen();
    // setBright(100)
    var soundLevelText = "tinymix set 16 7"
    system(soundLevelText);
}
function getWifiInfo(options) {

    // wpa_state=SCANNING
    // p2p_device_address=c2:f5:35:81:41:8e
    // address=c0:f5:35:81:41:8e
    // uuid=e1a83a1d-97b6-52eb-93f8-d323a8c9badf
    var switchOption = options + "="
    system("wpa_cli -p /tmp/wpa_supplicant/sockets -i wlan0 status > /tmp/wifi_status.txt");
    const statusContent = fs.read("/tmp/wifi_status.txt", "r");
    if (statusContent) {
        const statusLines = statusContent.split('\n');
        for (let i = 0; i < statusLines.length; i++) {
            const line = statusLines[i].trim();
            if (line.startsWith(switchOption)) {
                const state = line.split('=')[1];
                // if (state == "COMPLETED") {
                //     isConnected = true;
                //     break;
                // }
                return state;
            }
        }
    }
    return "FAil";
}
function getMacAddressFromLicenseFile() {
    // 生成 hexdump 命令
    var hexdumpCmd = "hexdump -s 0x0001 -n 6 -C /tmp/operation_license > /tmp/lic_status.txt";
    system(hexdumpCmd);

    // 读取 /tmp/lic_status.txt 文件内容
    const statusContent = fs.read("/tmp/lic_status.txt", "r");
    if (!statusContent) {
        console.log("Failed to read /tmp/lic_status.txt");
        return "FAIL";
    }

    // 解析 hexdump 输出
    const statusLines = statusContent.split('\n');
    for (let i = 0; i < statusLines.length; i++) {
        const line = statusLines[i].trim();
        if (line.startsWith("00000001")) {
            // 提取 MAC 地址部分
            const macPart = line.slice(10, 28).trim();
            // 替换空格为冒号并转换为小写
            const formattedMac = macPart.replace(/\s/g, ':').toLowerCase();
            return formattedMac;
        }
    }

    // 如果没有找到有效的 MAC 地址，返回 FAIL
    return "FAIL";
}


function setRtc(iso) {
    console.log("!!setRtc:" + iso);
    // const iso = "1999-10-03 19:50:00";
    const pure = iso.replace(/^AT\+WRITE_RTC=/, '');
    // 一次性解析
    const [datePart, timePart] = pure.split(' ');
    const [year, month, day] = datePart.split('-').map(Number);
    const [hour, minute, sec] = timePart.split(':').map(Number);
    console.log("!!-----:" + year + "," + month + "," + day + "," + hour + "," + minute + "," + sec);
    // 写入 RTC
    var librtc = require("rtc.js");
    librtc.ctrl("set", {
        year: year,
        month: month,
        day: day,
        hour: hour,
        minute: minute,
        second: sec          // 这里用解析出来的秒（示例 00）
    });
}

function getHostid() {
    //     root@TinaLinux:/# cat ./tmp/hostid.txt
    // 3469984A8F071DE627757D3CBAE131C1root@TinaLinux:/#
    var filePath1 = "/tmp/hostid.txt";
    var filePath2 = "/mnt/extsd/hostid.txt";
    var readfile;
    if (!fs.exists("../../../../.." + filePath1)) {
        if (!fs.exists("../../../../.." + filePath2)) {
            return "FAIL";
        }
        readfile = filePath2;
    } else {
        readfile = filePath1;
    }
    console.log("getHostid readfile: " + readfile);
    const raw = fs.read(readfile, "r");
    if (!raw) return 'FAIL';
    // 去掉首尾空白、换行、回车
    return raw.trim() || 'FAIL';
}
/* ========== 全局缓存 ========== */
var hostIdSegArray = [];   // 下标 = 段号-1


/**
 * 解析 HostId 分段数据
 * @param {string} recvBuf  原始 HEX 字符串
 * @returns {Object}  {code:0|1|3, data:'', msg:''}
 *   code=0 格式错误
 *        1 已缓存（非末段）
 *        3 末段已齐并返回完整 HEX
 */
function readHostIdData(recvBuf) {
    const HDR_HEX = '41542B57524954455F484F53544944'; // "AT+WRITE_HOSTID"
    const EQUAL = '3D';
    const TAIL = '0D0D0A0A';

    if (!recvBuf) return { code: 0, data: '', msg: 'empty buffer' };

    /* 1. 头 */
    const hdrPos = recvBuf.indexOf(HDR_HEX);
    if (hdrPos === -1) return { code: 0, data: '', msg: 'header not found' };
    let core = recvBuf.slice(hdrPos + HDR_HEX.length);

    /* 2. = */
    const eqPos = core.indexOf(EQUAL);
    if (eqPos === -1) return { code: 0, data: '', msg: 'equal not found' };
    core = core.slice(eqPos + EQUAL.length);

    /* 3. 去尾 */
    if (core.endsWith(TAIL)) core = core.slice(0, -TAIL.length);

    /* 4. 段号 01/08 */
    const slashPos = core.indexOf('2F');
    if (slashPos === -1) return { code: 0, data: '', msg: 'slash not found' };
    const curSegHex = core.slice(0, slashPos);
    const totSegHex = core.slice(slashPos + 2, slashPos + 6);
    const curSeg = hexToAscii(curSegHex);
    const totSeg = hexToAscii(totSegHex);
    if (isNaN(curSeg) || isNaN(totSeg)) return { code: 0, data: '', msg: 'seg parse fail' };

    /* 5. 数据 */
    const hexData = core.slice(slashPos + 6).replace(/\s+/g, '');
    if (!hexData) return { code: 0, data: '', msg: 'no data' };

    /* 6. 缓存 */
    hostIdSegArray[curSeg - 1] = hexData;

    /* 7. 末段判断 */
    if (curSeg === totSeg) {
        const fullHex = hostIdSegArray.join('');
        hostIdSegArray = [];          // 清空
        return { code: 3, data: fullHex, msg: 'completed' };
    }
    return { code: 1, data: '', msg: `segment ${curSeg}/${totSeg} cached` };
}

function gotoWriteHostIdData(fullHex) {
    console.log("fullHex: " + fullHex);
    if (gotoWriteHostIdData._timeOutId == undefined) {
        gotoWriteHostIdData._timeOutId = null;
    }

    // 清理之前的定时器
    if (gotoWriteHostIdData._timeOutId) {
        clearTimeout(gotoWriteHostIdData._timeOutId);
        gotoWriteHostIdData._timeOutId = null;
    }

    // // 设置新的定时器
    gotoWriteHostIdData._timeOutId = setTimeout(() => {


        const hostid = getHostid();
        const fileName = "/tmp/" + hostid + ".lic";



        var hexLen = fullHex.length;
        var result = uart.writeData(fullHex, hexLen, fileName);
        if (result == 1) {
            console.log("Data written successfully.");
        } else {
            console.log("Failed to write data.");
        }
        system("sync");
        system(SECURE_APP_PATH + " -b " + fileName);
        //         hostIdSegArray = [];          // 清空缓存
        // console.log('HostId 已全部写入：', recLic);
 

    }, 100);
}


/**
 * 计算 HostID 校验和
 * @param {string} s  输入字符串（已 trim）
 * @returns {string}  返回 "0xXX" 格式校验和
 */
function verifyHostIDChecksum() {
    var hostid = getHostid();
    var fileName = hostid + ".lic"

    console.log("HostId fileName: " + fileName);
    const filePath1 = "/tmp/" + fileName;
    const filePath2 = "/mnt/extsd/" + fileName;

    let readFile = null;
    if (fs.exists("../../../../.." + filePath1)) readFile = filePath1;
    else if (fs.exists("../../../../.." + filePath2)) readFile = filePath2;

    if (!readFile) return "0X00";          // 统一错误格式
    console.log("verifyHostIDChecksum readFile: " + readFile);
    const raw = fs.read(readFile, "r");
    console.log("verifyHostIDChecksum raw: " + raw);
    return raw ? calculateSumChecksum(raw) : "0X00";
}
/**
 * 计算字符串校验和（跳过 '-'，取低 8 位）
 * @param {string} s  输入字符串
 * @returns {string}  返回 "0xXX" 格式校验和
 */
function calculateSumChecksum(dataString) {
    console.log("calculateSumChecksum dataString: " + dataString);
    if (!dataString) return "0X00";

    try {
        // 1. 移除可能的空格并按连字符分割
        let parts = dataString.replace(/-/g, "");
        let totalSum = 0;

        // 2. 遍历每个字符，将其转换为整数并累加
        for (let i = 0; i < parts.length; i++) {
            totalSum += parseInt(parts[i], 10);
        }

        // 3. 取低 8 位 (等效于 totalSum & 0xFF)
        let checksum = "0X" + (totalSum & 0xFF).toString(16).toUpperCase().padStart(2, '0');

        console.log(`累加和为 ${checksum}`);
        return checksum;
    } catch (e) {
        console.error(`计算累加和校验时出错: 数据包含非数字部分。${e}`);
        return "0X00"; // 或返回错误码/None
    }
}


function system(cmd) {
    systemCtrl.executeSystemCommand(cmd)
}



module.exports = {
    startWifiScan: startWifiScan,
    getWifiScan: getWifiScan,
    writeSn: writeSn,
    getSn: getSn,
    getCrc: getCrc,
    getAutoStartMode: getAutoStartMode,
    setBright: setBright,
    ciclkAutoFactory: ciclkAutoFactory,
    getTempHum: getTempHum,
    writeLic: writeLic,
    formatHexWithSpace: formatHexWithSpace,
    initPage: initPage,
    setAutoModeUI: setAutoModeUI,
    initUI: initUI,
    ledTimerOut: ledTimerOut,
    exitAutoFactoryPage: exitAutoFactoryPage,
    licParce: licParce,
    figureChecksum: figureChecksum,
    testLicParce: testLicParce,
    initUartPWM: initUartPWM,
    devExist: devExist,
    checkUsbDeviceExist: checkUsbDeviceExist,
    getRtcTimer: getRtcTimer,
    setSsid: setSsid,
    getssid: getssid,
    initautoFactorySetting: initautoFactorySetting,
    getWifiInfo: getWifiInfo,
    gotoWriteLic: gotoWriteLic,
    getMacAddressFromLicenseFile: getMacAddressFromLicenseFile,
    setRtc: setRtc,
    getHostid: getHostid,
    readHostIdData: readHostIdData,
    gotoWriteHostIdData: gotoWriteHostIdData,
    verifyHostIDChecksum: verifyHostIDChecksum
}
