var dlfcn = require("dlfcna.js");
//console.log(dlfcn)

var funcs = [
    ["startFiveInch", "v"],
    ["closeFiveInch", "v"],
    ["read", "is"],
];

//console.log("in factory_fiveInch.js")
function register() {
    //console.log("will register fiveInch.so")
    var isSuccess = dlfcn.register("@native.fiveInch", "./lib/factory/fiveInch.so", funcs);
    if (isSuccess) {
        //console.log("load so successfully")
        var fiveInch = require("@native.fiveInch");
        return fiveInch
    } else {
        //console.log("load so failed")
    }
    return undefined;
}
var fiveInch = register();

function start() {
    fiveInch.startFiveInch();
}
function close() {
    fiveInch.closeFiveInch();
}
function read(option) {

//    option -> "data" // return "aaaaaaaaaaa"
//    option -> "author" // return "11"
   return fiveInch.read(option);
}

module.exports = {
    start: start,
    close: close,
    read: read,
}

