var dlfcn = require("dlfcna.js");
//console.log(dlfcn)

var funcs = [
    ["isWifi", "is"],
    ["getWifiSignalLevel", "is"],
    ["initWifi", "is"],
    ["getVersion", "ss"],
    ["syncSave", "is"],
    ["get_wifi_mac", "ss"],
];

//console.log("in factory_wifi.js")
function register() {
    //console.log("will register testWifi.so")
    var isSuccess = dlfcn.register("@native.wifi", "./lib/factory/testWifi.so", funcs);
    if (isSuccess) {
        //console.log("load so successfully")
        var wifi = require("@native.wifi");
        return wifi
    } else {
        //console.log("load so failed")
    }
    return undefined;
}
var wifi = register();

function testWifiConnect(word, SSID) {
    switch (word) {
        case "testWifi": {
            var ret = 0
            try {
                ret = wifi.isWifi(SSID);
            } catch (e) {
                ret = 0
                //console.log("!!!ERROR:" + e)
            }
            //console.log("ret[0]=" + ret);
            return ret;
        }
        case "getSignal": {
            var ret = 0
            try {
                ret = wifi.getWifiSignalLevel("signal");
            } catch (e) {
                ret = -999
                //console.log("!!!ERROR:" + e)
            }
            //console.log("ret[1]=" + ret);
            return ret;
        }
        default: {
            //console.log("ERROR:wifi testWifiConnect word undefined..")
        }
    }
}

function initWifiTest(word) {
    //console.log("start run initWifiTest function");
    switch (word) {
        case "init": {
            var ret = wifi.initWifi(word);
            //console.log(ret);
            return ret
            // break
        }
        default: {
            //console.log("ERROR:wifi initTest word undefined..")
        }
    }
}

function getSysVersion(word) {
    switch (word) {
        case "get": {
            let ret = "init";//normal=1.0.0
            try {
                ret = wifi.getVersion(word);
            } catch (e) {
                ret = "1.0.0"
                //console.log("!!!ERROR:" + e)
            }
            //console.log("ret=" + ret);
            return ret
            // break
        }
        default: {
            //console.log("ERROR:wifi getSysVersion word undefined..")
        }
    }
}

function syncSave(word) {
    switch (word) {
        case "save": {
            let ret = 1;
            try {
                ret = wifi.syncSave(word);
            } catch (e) {
                ret = 1
                //console.log("!!!ERROR:" + e)
            }
            //console.log("ret=" + ret);
            return ret
        }
        default: {
            //console.log("ERROR:wifi getSysVersion word undefined..")
        }
    }
}
function getWifiMac() {
    //console.log("getWifiMac///////////////////////////////////////////");
    var mac = undefined
    try {
        mac = wifi.get_wifi_mac();
    } catch (e) {
        mac = "00:11:22:33:44:55"
        //console.log("!!!ERROR:" + e)
    }
    //console.log("mac=" + mac);
    return mac;
}


module.exports = {
    testWifiConnect: testWifiConnect,
    initWifiTest: initWifiTest,
    getSysVersion: getSysVersion,
    syncSave: syncSave,
    getWifiMac: getWifiMac
}

