
var _userdata = require("userdata.js");
var userData = _userdata.userData;
const fs = require("@system.fs");
var systemCtrl = require("systemCtrl.js");
var lvgl = require("@native.lvgl7");
var id_testRtcTimer = null;
var that;
var rtcCtl = require("factory_rtc.js");
var cntTime = 0;
var cntSuccess = 0;
function system(str) {
    systemCtrl.executeSystemCommand(str);
}


function exitTestRTC() {
    if (id_testRtcTimer != null) {
        clearInterval(id_testRtcTimer);
        id_testRtcTimer == null;
    }
}

function factoryTestRTCInit(obj) {
    that = obj;
    if (id_testRtcTimer != null) {
        clearInterval(id_testRtcTimer);
        id_testRtcTimer == null;
        cntTime = 0;
        cntSuccess = 0;
    }
    updateRtcInfo();
    id_testRtcTimer = setInterval(() => {
        cntTime += 1;
        updateRtcInfo();
    }, 1000);
}
function setTextColorById(that, id, value) {
    const color = (value === "NA") ? "#ff0000" : "#00ff00";
    that.$setTextColor(id, color);
}
function setTextColorByText(that, id, value) {
    var color;
    if (value === "测试失败") {
        color = "#ff0000";
    }
    else if (value === "检测中...") {
        color = "#ff8400";
    }
    else {
        color = "#00ff00";
    }
    that.$setTextColor(id, color);
}
var testCnt = 3
function updateRtcInfo() {
    var rtc = getRtcTime();
    that.crtLocalTime = rtc;
    //console.log("hwRtc:" + rtc);



    setTextColorById(that, 'id_crtLocalTime', that.crtLocalTime);


    var values = [that.crtLocalTime];
    var allValuesValid = values.every(value => value !== "NA");
    console.log("allValuesValid:" + allValuesValid);
    // 根据检查结果设置烧录测试状态




    console.log(`[RTC] 第 ${cntTime} 次检测，状态：${allValuesValid == true ? "有效" : "无效"}`);
    if (allValuesValid == 1) {
        cntSuccess += 1;
    } else {
        cntSuccess = 0;
    }
    if (cntTime < testCnt) {
        that.crtTextRtcText = "检测中...";
        setTextColorByText(that, 'id_crtTextRtcText', that.crtTextRtcText);
        that.$setY("id_yes", -480);
        return; // 不继续判断
    }

    // 第2次检测完成，设置最终结果

    that.crtTextRtcText = cntSuccess > testCnt ? "测试通过" : "测试失败";
    setTextColorByText(that, 'id_crtTextRtcText', that.crtTextRtcText);
    globalThis.factoryTest.rtc = cntSuccess > testCnt ? 1 : 2;
    that.$setY("id_yes", cntSuccess > testCnt ? 0 : -480);
    console.log("[RTC] 测试完成，最终状态：" + (cntSuccess > testCnt ? "通过" : "失败"));
    // cntTime = 0;
    // 可选：停止定时器
    // exitTestRTC();
    checkAutoFactory();

}
function checkAutoFactory() {
    require("factory_testAuto.js").autoFactoryNextPage("factoryTestRtc");
}

function getRtcTime() {
    // hwclock -f /dev/rtc1
    // /dev/rtc1
    var partFilePath = "../../../../../dev/rtc1";
    if (!fs.exists(partFilePath)) {
        return "NA";
    }
    system("hwclock -f /dev/rtc1 > /tmp/hwRtc.txt");
    const coresStr = fs.read("/tmp/hwRtc.txt", "r");
    if (coresStr) {
        return coresStr.split('\n');
    } else {
        // system("killall -9 /dev/rtc0");
        return "NA";
    }
}




module.exports = {
    factoryTestRTCInit: factoryTestRTCInit,
    exitTestRTC: exitTestRTC


}