import request from "@/utils/request";

export function getTemplate(params) {
  return request({
      url: "/report/reportmanage/templatesList",
      method: "get",
      params,
  });
}

export function getReport(data) {
  return request({
      url: "/report/reportmanage/pdfGenerate",
      method: "post",
      data,
  });
}

export function getWorkbenckData(params) {
  return request({
    url: "/api/v1/evm_store/workbench/query",
    method: "post",
    data: params,
  });
}

export function doLogin(params) {
  return request({
    url: "/api/v1/evm_store/login/login",
    method: "post",
    data: params,
  });
}

export function doLogout(params) {
  return request({
    url: "/api/v1/evm_store/login/logout",
    method: "post",
    data: params,
  });
}

export function doRegister(params) {
  return request({
    url: "/api/v1/evm_store/login/register",
    method: "post",
    data: params,
  });
}

export function addUser(params) {
  // 增
  return request({
    url: "/api/v1/evm_store/user/add",
    method: "post",
    data: params,
  });
}

export function deleteUser(id) {
  // 删
  return request({
    url: `/api/v1/evm_store/user/delete/${id}`,
    method: "post",
  });
}

export function getUser(params) {
  return request({
    url: "/api/v1/evm_store/user/get",
    method: "post",
    data: params,
  });
}

export function getUserList(params) {
  // 查
  return request({
    url: "/api/v1/evm_store/user/list",
    method: "post",
    data: params,
  });
}

export function updateUser(id, params) {
  // 改
  return request({
    url: `/api/v1/evm_store/user/update/${id}`,
    method: "post",
    data: params,
  });
}

export function updateUserPassword(params) {
  return request({
    url: "/api/v1/evm_store/updatePassword",
    method: "post",
    data: params,
  });
}

export function addDepot(params) {
  return request({
    url: "/api/v1/evm_store/depot/add",
    method: "post",
    data: params,
  });
}

export function deleteDepot(id) {
  return request({
    url: `/api/v1/evm_store/depot/delete/${id}`,
    method: "post",
  });
}

export function getDepotList(params) {
  return request({
    url: "/api/v1/evm_store/depot/list",
    method: "post",
    data: params,
  });
}

export function updateDepot(id, params) {
  return request({
    url: `/api/v1/evm_store/depot/update/${id}`,
    method: "post",
    data: params,
  });
}

export function getDictsList(params) {
  return request({
    url: "/api/v1/evm_store/dict/list",
    method: "post",
    data: params,
  });
}

export function addDict(params) {
  return request({
    url: "/api/v1/evm_store/dict/add",
    method: "post",
    data: params,
  });
}

export function updateDict(id, params) {
  return request({
    url: `/api/v1/evm_store/dict/update/${id}`,
    method: "post",
    data: params,
  });
}

export function deleteDict(id) {
  return request({
    url: `/api/v1/evm_store/dict/delete/${id}`,
    method: "post",
  });
}

export function getProject(params) {
  return request({
    url: "/api/v1/evm_store/project/get",
    method: "post",
    data: params,
  });
}

export function getProjectList(params) {
  return request({
    url: "/api/v1/evm_store/project/list",
    method: "post",
    data: params,
  });
}

export function addProject(params) {
  return request({
    url: "/api/v1/evm_store/project/add",
    method: "post",
    data: params,
  });
}

export function updateProject(id, params) {
  return request({
    url: `/api/v1/evm_store/project/update/${id}`,
    method: "post",
    data: params,
  });
}

export function deleteProject(id) {
  return request({
    url: `/api/v1/evm_store/project/delete/${id}`,
    method: "post",
  });
}

export function getRoleList(params) {
  return request({
    url: "/api/v1/evm_store/role/list",
    method: "post",
    data: params,
  });
}

export function addRole(params) {
  return request({
    url: "/api/v1/evm_store/role/add",
    method: "post",
    data: params,
  });
}

export function updateRole(id, params) {
  return request({
    url: `/api/v1/evm_store/role/update/${id}`,
    method: "post",
    data: params,
  });
}

export function deleteRole(id) {
  return request({
    url: `/api/v1/evm_store/role/delete/${id}`,
    method: "delete",
  });
}

export function getWatchList() {
  return request({
    url: "/api/v1/evm_store/watch",
    method: "get",
  });
}

export function getMonitorData(params) {
  return request({
    url: "/api/v1/evm_store/monitor",
    method: "get",
    params,
  });
}

export function updatePermission(id, params) {
  return request({
    url: `/api/v1/evm_store/permission/update/${id}`,
    method: "post",
    data: params,
  });
}

export function deletePermission(id) {
  return request({
    url: `/api/v1/evm_store/permission/delete/${id}`,
    method: "post",
  });
}

export function addNewProject(params) {
  return request({
    url: "/api/v1/evm_store/system/addProject",
    method: "post",
    data: params,
  });
}

export function exportProject(params) {
  return request({
    url: "/api/v1/evm_store/system/exportProject",
    method: "post",
    data: params,
  });
}

export function addFlow(params) {
  return request({
    url: "/api/v1/evm_store/flow/add",
    method: "post",
    data: params,
  });
}

export function updateFlow(id, params) {
  return request({
    url: `/api/v1/evm_store/flow/update/${id}`,
    method: "post",
    data: params,
  });
}

export function deleteFlow(id) {
  return request({
    url: `/api/v1/evm_store/flow/delete/${id}`,
    method: "delete",
  });
}

export function getFlowList(params) {
  return request({
    url: "/api/v1/evm_store/system/getFlowList",
    method: "post",
    data: params,
  });
}

export function addPayback(params) {
  return request({
    url: "/api/v1/evm_store/payback/add",
    method: "post",
    data: params,
  });
}

export function updatePayback(id, params) {
  return request({
    url: `/api/v1/evm_store/payback/update/${id}`,
    method: "post",
    data: params,
  });
}

export function deletePayback(id) {
  return request({
    url: `/api/v1/evm_store/payback/delete/${id}`,
    method: "post",
  });
}

export function getPaybackList(params) {
  return request({
    url: "/api/v1/evm_store/system/getPaybackList",
    method: "post",
    data: params,
  });
}

export function deleteProjectUser(params) {
  return request({
    url: "/api/v1/evm_store/system/deleteProjectUser",
    method: "post",
    data: params,
  });
}

export function modifyProjectUser(params) {
  return request({
    url: "/api/v1/evm_store/system/modifyProjectUser",
    method: "post",
    data: params,
  });
}

export function updateFlowList(params) {
  return request({
    url: "/api/v1/evm_store/system/updateFlow",
    method: "post",
    data: params,
  });
}

export function updatePaybackList(params) {
  return request({
    url: "/api/v1/evm_store/system/updatePayback",
    method: "post",
    data: params,
  });
}

export function updateProduction(params) {
  return request({
    url: "/api/v1/evm_store/system/updateProductionPlan",
    method: "post",
    data: params,
  });
}

export function getCalendarList(params) {
  return request({
    url: "/api/v1/evm_store/calendar/list",
    method: "post",
    data: params,
  });
}

export function addCalendar(params) {
  return request({
    url: "/api/v1/evm_store/calendar/add",
    method: "post",
    data: params,
  });
}

export function updateCalendar(id, params) {
  return request({
    url: `/api/v1/evm_store/calendar/update/${id}`,
    method: "post",
    data: params,
  });
}

export function deleteCalendar(id) {
  return request({
    url: `/api/v1/evm_store/calendar/delete/${id}`,
    method: "post",
  });
}

export function getRoleUser(params) {
  return request({
    url: '/api/v1/evm_store/system/getRoleUsers',
    method: 'post',
    data: params,
  })
}

export function getSummaryList(params) {
  return request({
    url: "/api/v1/evm_store/summary/list",
    method: 'post',
    data: params,
  });
}

export function addSummary(params) {
  return request({
    url: "/api/v1/evm_store/summary/add",
    method: "post",
    data: params,
  });
}

export function updateSummary(id, params) {
  return request({
    url: `/api/v1/evm_store/summary/update/${id}`,
    method: "post",
    data: params,
  });
}

export function deleteSummary(id) {
  return request({
    url: `/api/v1/evm_store/summary/delete/${id}`,
    method: "post",
  });
}

export function getProductionPlanList(params) {
  return request({
    url: "/api/v1/evm_store/productionPlan/list",
    method: 'post',
    data: params,
  });
}

export function addProductionPlan(params) {
  return request({
    url: "/api/v1/evm_store/productionPlan/add",
    method: "post",
    data: params,
  });
}

export function updateProductionPlan(id, params) {
  return request({
    url: `/api/v1/evm_store/productionPlan/update/${id}`,
    method: "post",
    data: params,
  });
}

export function deleteProductionPlan(id) {
  return request({
    url: `/api/v1/evm_store/productionPlan/delete/${id}`,
    method: "post",
  });
}

export function getFileList(params) {
  return request({
    url: "/api/v1/evm_store/netdisc/list",
    method: "post",
    data: params,
  });
}

export function addFile(params) {
  return request({
    url: "/api/v1/evm_store/netdisc/add",
    method: "post",
    data: params,
  });
}

export function updateFile(id, params) {
  return request({
    url: `/api/v1/evm_store/netdisc/update/${id}`,
    method: "post",
    data: params,
  });
}

export function deleteFile(params) {
  return request({
    url: "/api/v1/evm_store/netdisc/delete",
    method: "post",
    data: params,
  });
}
