import request from "@/utils/request";

export function setTemplate(data) {
  return request({
    url: "/report/reportmanage/setTemplate",
    method: "post",
    data,
  });
}

export function getTemplate(params) {
  return request({
    url: "/report/reportmanage/templatesList",
    method: "get",
    params,
  });
}

export function getReport(data) {
  return request({
    url: "/report/reportmanage/pdfGenerate",
    method: "post",
    data,
  });
}

export function getWatchList() {
  return request({
    url: "/api/v1/evm_store/watch",
    method: "get",
  });
}

export function getMonitorData(params) {
  return request({
    url: "/api/v1/evm_store/monitor",
    method: "get",
    params,
  });
}

export function addApp(params) {
  return request({
    url: "/api/v1/evm_store/apps/add",
    method: "post",
    data: params,
  });
}

export function getAppsList(params) {
  return request({
    url: "/api/v1/evm_store/apps/list",
    method: "post",
    data: params,
  });
}

export function updateApp(id, params) {
  return request({
    url: `/api/v1/evm_store/apps/update/${id}`,
    method: "post",
    data: params,
  });
}

export function deleteApp(id) {
  return request({
    url: `/api/v1/evm_store/apps/delete/${id}`,
    method: "post",
  });
}

export function getBuildApp(id) {
  return request({
    url: `/api/v1/evm_store/apps/getBuildApp/${id}`,
    method: "post",
  });
}

export function rebuildApp(params) {
  return request({
    url: "/api/v1/evm_store/apps/get",
    method: "post",
    data: params,
  });
}

export function buildApp(id) {
  return request({
    url: `/api/v1/evm_store/apps/build/${id}`,
    method: "post",
  });
}

export function getBuildLogsList(params) {
  return request({
    url: "/api/v1/evm_store/apps/buildLogs",
    method: "post",
    data: params,
  });
}

export function getDownloadList(params) {
  return request({
    url: "/api/v1/evm_store/download/list",
    method: "post",
    data: params,
  });
}

export function addDownload(params) {
  return request({
    url: "/api/v1/evm_store/download/add",
    method: "post",
    data: params,
  });
}

export function updateDownload(id, params) {
  return request({
    url: `/api/v1/evm_store/download/update/${id}`,
    method: "post",
    data: params,
  });
}

export function deleteDownload(params) {
  return request({
    url: "/api/v1/evm_store/framework/delete",
    method: "post",
    data: params,
  });
}

export function addDevice(params) {
  return request({
    url: "/api/v1/evm_store/device/add",
    method: "post",
    data: params,
  });
}

export function deleteDevice(id) {
  return request({
    url: `/api/v1/evm_store/device/delete/${id}`,
    method: "post",
  });
}

export function getDeviceList(params) {
  return request({
    url: "/api/v1/evm_store/device/list",
    method: "post",
    data: params,
  });
}

export function updateDevice(id, params) {
  return request({
    url: `/api/v1/evm_store/device/update/${id}`,
    method: "post",
    data: params,
  });
}

export function addUser(params) {
  // 增
  return request({
    url: "/api/v1/evm_store/user/add",
    method: "post",
    data: params,
  });
}

export function deleteUser(id) {
  // 删
  return request({
    url: `/api/v1/evm_store/user/delete/${id}`,
    method: "post",
  });
}

export function getUser(params) {
  return request({
    url: "/api/v1/evm_store/user/get",
    method: "post",
    data: params,
  });
}

export function getUserList(params) {
  // 查
  return request({
    url: "/api/v1/evm_store/user/list",
    method: "post",
    data: params,
  });
}

export function updateUser(id, params) {
  // 改
  return request({
    url: `/api/v1/evm_store/user/update/${id}`,
    method: "post",
    data: params,
  });
}

export function updateUserPassword(params) {
  return request({
    url: "/api/v1/evm_store/updatePassword",
    method: "post",
    data: params,
  });
}

export function doLogin(params) {
  return request({
    url: "/api/v1/evm_store/login/login",
    method: "post",
    data: params,
  });
}

export function doLogout(params) {
  return request({
    url: "/api/v1/evm_store/login/logout",
    method: "post",
    data: params,
  });
}

export function doRegister(params) {
  return request({
    url: "/api/v1/evm_store/login/register",
    method: "post",
    data: params,
  });
}

export function addAppLogs(params) {
  return request({
    url: "/api/v1/evm_store/appLogs/add",
    method: "post",
    data: params,
  });
}

export function deleteAppLogs(params) {
  return request({
    url: "/api/v1/evm_store/appLogs/delete",
    method: "post",
    data: params,
  });
}

export function getAppLogsList(params) {
  return request({
    url: "/api/v1/evm_store/appLogs/list",
    method: "post",
    data: params,
  });
}

export function updateAppLogs(params) {
  return request({
    url: "/api/v1/evm_store/appLogs/update",
    method: "post",
    data: params,
  });
}

export function getConvertString(params) {
  return request({
    url: "/api/v1/evm_store/system/convertString",
    method: "post",
    data: params,
  });
}

export function actionOpqcp(params) {
  return request({
    url: "/api/v1/evm_store/opqcp",
    method: "post",
    data: params,
  });
}

export function getTopicList(params) {
  return request({
    url: "/uowap/index",
    method: "get",
    params,
  });
}

export function getTabList(params) {
  return request({
    url: "/uowap/index",
    method: "get",
    params,
  });
}

export function getAppList(params) {
  return request({
    url: "/uowap/index",
    method: "get",
    params,
  });
}

export function getDataList(params) {
  return request({
    url: "/uowap/index",
    method: "get",
    params,
  });
}
