
# -*- coding: utf-8 -*-
import sys

header = \
u'''
/****************************************************************************
**
** Copyright (C) 2021 @scriptiot
**
**  EVM是一款通用化设计的虚拟机引擎，拥有语法解析前端接口、编译器、虚拟机和虚拟机扩展接口框架。
**  支持js、python、qml、lua等多种脚本语言，纯Ｃ开发，零依赖，支持主流 ROM > 50KB, RAM > 2KB的MCU;
**  自带垃圾回收（GC）先进的内存管理，采用最复杂的压缩算法，无内存碎片（大部分解释器都存在内存碎片）
**  Version : 3.0
**  Email   : scriptiot@aliyun.com
**  Website : https://github.com/scriptiot
**  Licence: MIT Licence
****************************************************************************/
'''


def cstr_encode(text, splitLines=True, escapePercent=False):
    output = "\""
    count = len(text)
    for i in range(count):
        if text[i] == '\f':
            output += "\\f"
        elif text[i] == '\n':
            if splitLines:
                output += "\\n\"\n\""
            else:
                output += "\\n";            
        elif text[i] == '\r':
            output += "\\r"
        elif text[i] == '\t':
            output += "\\t"
        elif text[i] == '\"':
            output += "\\\""
        elif text[i] == '\\':
            output += "\\\\"
        elif text[i] == '%':
            if escapePercent:
                output += "%%"
            else:
                output += "%"
        else:
            output += text[i]
    output += "\""
    return output


def convert(fpath):
    with open(fpath, "r") as f:
        content = f.read()
    ret = cstr_encode(content)

    ccode = "%s\nconst char * appjs_content=\\\n%s;" % (header, ret)

    with open("appjs.c", "w", encoding="utf-8") as f:
        f.write(ccode)
    return ccode

def convert_string(string):
    return "%s\nconst char * appjs_content=\\\n%s;" % (header, cstr_encode(string))

if __name__ == '__main__':
    ret = convert(sys.argv[1])
    print(ret)
