'''
Author: your name
Date: 2021-04-14 14:12:18
LastEditTime: 2021-07-01 14:45:00
LastEditors: your name
Description: In User Settings Edit
FilePath: \evm-store\backend\view\app_logs.py
'''
#!/usr/bin/env python
# -*- coding: utf_8 -*-
import logging
import traceback
from flask import Blueprint, request
from app import config, signalManager
from fullstack.login import Auth
from fullstack.validation import validate_schema
from fullstack.response import ResponseCode, response_result
from schema.app_logs import AddSchema, DeleteSchema, QuerySchema, UpdateSchema

logger = logging.getLogger(__name__)

appLogs_api = Blueprint("appLogs_api", __name__, url_prefix="/api/v1/%s/appLogs" % config['NAME'])

@appLogs_api.route("/add", methods=['POST'])
@validate_schema(AddSchema)
@Auth.auth_required
def add():
    try:
        user = request.current_user.get("id")
        isSuccess, message = signalManager.actionAddAppLogs.emit(user, request.schema_data)
        if isSuccess:
            return response_result(ResponseCode.OK, msg=message)
        else:
            return response_result(ResponseCode.REQUEST_ERROR, msg=message)
    except Exception as e:
        traceback.print_exc()
        logger.error(str(e))
        return response_result(ResponseCode.SERVER_ERROR, msg=str(e))


@appLogs_api.route("/delete/<uuid:id>", methods=['POST'])
@validate_schema(DeleteSchema)
@Auth.auth_required
def delete(id):
    try:
        user = request.current_user.get("id")
        isSuccess, message = signalManager.actionDeleteAppLogs.emit(user, id)
        if isSuccess:
            return response_result(ResponseCode.OK, msg=message)
        else:
            return response_result(ResponseCode.REQUEST_ERROR, msg=message)
    except Exception as e:
        traceback.print_exc()
        logger.error(str(e))
        return response_result(ResponseCode.SERVER_ERROR)


@appLogs_api.route("/get", methods=["POST"])
@validate_schema(QuerySchema)
@Auth.auth_required
def get():
    try:
        user = request.current_user.get("id")
        result, message = signalManager.actionGetAppLogs.emit(user, request.schema_data)
        if result:
            return response_result(ResponseCode.OK, data=result, msg=message)
        else:
            return response_result(ResponseCode.REQUEST_ERROR, msg=message)
    except Exception as e:
        traceback.print_exc()
        logger.error(str(e))
        return response_result(ResponseCode.SERVER_ERROR, msg=str(e))


@appLogs_api.route("/list", methods=['POST'])
@validate_schema(QuerySchema)
@Auth.auth_required
def get_list():
    try:
        user = request.current_user.get("id")
        result, count, message = signalManager.actionGetAppLogsList.emit(user, request.schema_data)
        if result:
            return response_result(ResponseCode.OK, data=result, msg=message, count=count)
        else:
            return response_result(ResponseCode.REQUEST_ERROR, msg=message)
    except Exception as e:
        traceback.print_exc()
        logger.error(str(e))
        return response_result(ResponseCode.SERVER_ERROR)


@appLogs_api.route("/update/<uuid:id>", methods=['POST'])
@validate_schema(UpdateSchema)
@Auth.auth_required
def update(id):
    try:
        user = request.current_user.get("id")
        isSuccess, message = signalManager.actionUpdateAppLogs.emit(user, id, request.schema_data)
        if isSuccess:
            return response_result(ResponseCode.OK, msg=message)
        else:
            return response_result(ResponseCode.REQUEST_ERROR, msg=message)
    except Exception as e:
        traceback.print_exc()
        logger.error(str(e))
        return response_result(ResponseCode.SERVER_ERROR)
