from . import BaseSchema
from marshmallow import fields, validate, RAISE, INCLUDE, EXCLUDE

'''
默认情况下，如果在架构中遇到不匹配的键，load将引发a 。ValidationErrorField
可以使用unknown选项修改此行为，该选项接受以下之一：

    RAISE（默认）：ValidationError 如果存在未知字段，则引发
    EXCLUDE：排除未知字段
    INCLUDE：接受并包含未知字段

您可以unknown在类的Meta中指定Schema
'''

class AddSchema(BaseSchema):
    account = fields.String(required=True)
    username = fields.String(required=False)
    password = fields.String(required=True)
    email = fields.Email(required=False, default="")
    phone = fields.String(required=False, default="")
    gender = fields.Int(required=False, default=1)
    birthday = fields.Date(required=False, default=None)
    role = fields.String(required=False)
    remarks = fields.String(required=False)

    class Meta:
        unknown = EXCLUDE

class DeleteSchema(BaseSchema):
    class Meta:
        unknown = EXCLUDE

class UpdateSchema(BaseSchema):
    uuid = fields.UUID(required=False)
    account = fields.String(required=False)
    username = fields.String(required=False)
    email = fields.Email(required=False)
    phone = fields.String(required=False)
    gender = fields.Int(required=False)
    birthday = fields.Date(required=False)
    role = fields.String(required=False)
    remarks = fields.String(required=False)

    class Meta:
        unknown = EXCLUDE

class QuerySchema(BaseSchema):
    uuid = fields.UUID(required=False)
    scope_type = fields.String(required=False)
    pagenum = fields.Int(required=False)
    pagesize = fields.Int(required=False, max=50) # 防止用户传特别大的数，导致数据库查询阻塞

    class Meta:
        unknown = EXCLUDE

class ResponseSchema(BaseSchema):
    uuid = fields.UUID(required=True)
    account = fields.String(required=True)
    username = fields.String(required=True)
    password = fields.String(required=True)
    email = fields.Email(required=False)
    phone = fields.String(required=True)
    gender = fields.Int(required=True)
    birthday = fields.Date(required=False)
    remarks = fields.String(required=True)

    class Meta:
        unknown = INCLUDE