from datetime import datetime
from . import BaseSchema
from marshmallow import fields, validate, RAISE, INCLUDE, EXCLUDE

class QuerySchema(BaseSchema):
    project = fields.UUID(required=True)

    class Meta:
        unknown = EXCLUDE

class QueryPaybackSchema(BaseSchema):
    project = fields.UUID(required=True)

    class Meta:
        unknown = EXCLUDE

class DeleteProjectUserSchema(BaseSchema):
    uuid = fields.UUID(required=True)
    project = fields.UUID(required=True)

    class Meta:
        unknown = EXCLUDE

class ModifyProjectUserSchema(BaseSchema):
    users = fields.List(fields.UUID, required=True)
    project = fields.UUID(required=True)

    class Meta:
        unknown = EXCLUDE

class UpdateFlowSchema(BaseSchema):
    flow = fields.List(fields.Dict(required=True), required=True)
    uuid = fields.UUID(required=True)

    class Meta:
        unknown = EXCLUDE

class UpdatePaybackSchema(BaseSchema):
    payback = fields.List(fields.Dict(required=True), required=True)
    uuid = fields.UUID(required=True)

    class Meta:
        unknown = EXCLUDE

class UpdateProductionSchema(BaseSchema):
    production = fields.Dict(required=True)
    uuid = fields.UUID(required=True)

    class Meta:
        unknown = EXCLUDE