from datetime import datetime
from . import BaseSchema
from marshmallow import fields, validate, RAISE, INCLUDE, EXCLUDE

class AddSchema(BaseSchema):
    title = fields.String(required=True, validate=validate.Length(min=2, max=50))
    funds = fields.Float(required=True)
    type = fields.Int(required=True)
    status = fields.Int(required=True, default=1)
    project = fields.UUID(required=False)
    plan_time = fields.DateTime(required=False)
    real_time = fields.DateTime(required=True)

    class Meta:
        unknown = EXCLUDE

class UpdateSchema(BaseSchema):
    title = fields.String(required=False, validate=validate.Length(min=2, max=50))
    funds = fields.Float(required=False)
    type = fields.Int(required=False)
    status = fields.Int(required=False) # 回款状态
    plan_time = fields.DateTime(required=False)
    real_time = fields.DateTime(required=False)

    class Meta:
        unknown = EXCLUDE

class DeleteSchema(BaseSchema):
    class Meta:
        unknown = EXCLUDE

class QuerySchema(BaseSchema):
    uuid = fields.UUID(required=False)
    title = fields.String(required=False, validate=validate.Length(min=2, max=20))
    pagenum = fields.Int(required=False)
    pagesize = fields.Int(required=False, max=50) # 防止用户传特别大的数，导致数据库查询阻塞

    class Meta:
        unknown = EXCLUDE

class ResponseSchema(BaseSchema):
    uuid = fields.UUID(required=False)
    funds = fields.Float(required=True)
    type = fields.Int(required=False)
    project = fields.Int(required=False)
    title = fields.String(required=True, validate=validate.Length(min=2, max=50))
    plan_time = fields.DateTime(required=True)
    real_time = fields.DateTime(required=True)
    create_at = fields.DateTime(required=False, default=datetime.now)
    update_at = fields.DateTime(required=False, default=datetime.now)

    class Meta:
        unknown = INCLUDE
