from datetime import datetime
from . import BaseSchema
from marshmallow import fields, validate, RAISE, INCLUDE, EXCLUDE

class AddSchema(BaseSchema):
    name = fields.String(required=False)
    parent_dir = fields.String(required=False)
    file_type = fields.String(required=False)

    class Meta:
        unknown = EXCLUDE

class UpdateSchema(BaseSchema):
    name = fields.String(required=True)
    parent_dir = fields.String(required=False)
    file_type = fields.String(required=False)

    class Meta:
        unknown = EXCLUDE

class DeleteSchema(BaseSchema):
    uuids = fields.List(fields.UUID, required=True)

    class Meta:
        unknown = EXCLUDE

class QuerySchema(BaseSchema):
    uuid = fields.UUID(required=False)
    name = fields.String(required=False)
    parent_dir = fields.String(required=False)
    file_type = fields.String(required=False)

    class Meta:
        unknown = EXCLUDE

class ResponseSchema(BaseSchema):
    uuid = fields.UUID(required=True)
    name = fields.String(required=True)
    create_at = fields.DateTime(required=False, default=datetime.now)
    update_at = fields.DateTime(required=False, default=datetime.now)

    class Meta:
        unknown = INCLUDE
