'''
Author: your name
Date: 2021-04-14 14:12:18
LastEditTime: 2021-07-14 12:42:49
LastEditors: Please set LastEditors
Description: In User Settings Edit
FilePath: \evm-store\backend\schema\download.py
'''
from datetime import datetime
from . import BaseSchema
from marshmallow import fields, validate, RAISE, INCLUDE, EXCLUDE

class AddSchema(BaseSchema):
    app = fields.String(required=True)
    imei = fields.String(required=True)

    class Meta:
        unknown = EXCLUDE

class UpdateSchema(BaseSchema):
    app = fields.String(required=False)
    imei = fields.String(required=False)

    class Meta:
        unknown = EXCLUDE

class DeleteSchema(BaseSchema):
    class Meta:
        unknown = EXCLUDE

class DownloadSchema(BaseSchema):
    id = fields.String(required=True)
    imei = fields.String(required=True)
    byId = fields.Integer(required=False)

    class Meta:
        unknown = EXCLUDE

class QuerySchema(BaseSchema):
    uuid = fields.UUID(required=False)
    scope_type = fields.String(required=False)
    pagenum = fields.Int(required=False)
    pagesize = fields.Int(required=False, max=50) # 防止用户传特别大的数，导致数据库查询阻塞

    class Meta:
        unknown = EXCLUDE

class ResponseSchema(BaseSchema):
    uuid = fields.UUID(required=False)
    create_at = fields.DateTime(required=False, default=datetime.now)
    update_at = fields.DateTime(required=False, default=datetime.now)

    class Meta:
        unknown = INCLUDE
