from datetime import datetime
from . import BaseSchema
from marshmallow import fields, validate, RAISE, INCLUDE, EXCLUDE

class AddSchema(BaseSchema):
    label = fields.String(required=True, validate=validate.Length(min=1, max=50))
    value = fields.String(required=True, validate=validate.Length(min=1, max=50))
    category = fields.String(required=True, validate=validate.Length(min=1, max=50))
    sort = fields.Integer(required=False, default=0, allow_none=True)
    remarks = fields.String(required=False, default=" ", allow_none=True)
    is_system = fields.Boolean(required=False, default=False, allow_none=True)

    class Meta:
        unknown = EXCLUDE

class UpdateSchema(BaseSchema):
    label = fields.String(required=False, validate=validate.Length(min=1, max=50))
    value = fields.String(required=False, validate=validate.Length(min=1, max=50))
    category = fields.String(required=False, validate=validate.Length(min=1, max=50))
    sort = fields.Integer(required=False)
    remarks = fields.String(required=False)

    class Meta:
        unknown = EXCLUDE

class DeleteSchema(BaseSchema):
    class Meta:
        unknown = EXCLUDE

class QuerySchema(BaseSchema):
    uuid = fields.UUID(required=False)
    scope_type = fields.String(required=False)
    is_category = fields.Integer(required=False)
    label = fields.String(required=False, validate=validate.Length(min=1, max=20))
    value = fields.String(required=False, validate=validate.Length(min=1, max=20))
    category = fields.List(fields.String(validate=validate.Length(min=1, max=50)), required=False)
    pagenum = fields.Int(required=False)
    pagesize = fields.Int(required=False, max=50) # 防止用户传特别大的数，导致数据库查询阻塞

    class Meta:
        unknown = EXCLUDE

class ResponseSchema(BaseSchema):
    uuid = fields.UUID(required=False)
    enabld_delete = fields.Boolean(required=True,)
    label = fields.String(required=False, validate=validate.Length(min=1, max=50))
    value = fields.String(required=False, validate=validate.Length(min=1, max=50))
    category = fields.String(required=False, validate=validate.Length(min=1, max=50))
    create_at = fields.DateTime(required=False, default=datetime.now)
    update_at = fields.DateTime(required=False, default=datetime.now)

    class Meta:
        unknown = INCLUDE
