from datetime import datetime
from . import BaseSchema
from marshmallow import fields, validate, RAISE, INCLUDE, EXCLUDE

class AddSchema(BaseSchema):
    name = fields.String(required=True)
    imei = fields.String(required=True)
    desc = fields.String(required=False)
    type = fields.String(required=False)
    sort = fields.Integer(required=False, default=0, allow_none=True)
    remarks = fields.String(required=False, default="", allow_none=True)
    is_system = fields.Boolean(required=False, default=False, allow_none=True)

    class Meta:
        unknown = EXCLUDE

class UpdateSchema(BaseSchema):
    name = fields.String(required=False)
    imei = fields.String(required=False)
    desc = fields.String(required=False)
    type = fields.String(required=False)
    sort = fields.Integer(required=False)
    remarks = fields.String(required=False)

    class Meta:
        unknown = EXCLUDE

class DeleteSchema(BaseSchema):
    class Meta:
        unknown = EXCLUDE

class QuerySchema(BaseSchema):
    uuid = fields.UUID(required=False)
    scope_type = fields.String(required=False)
    type = fields.Integer(required=False)
    pagenum = fields.Int(required=False)
    pagesize = fields.Int(required=False, max=50) # 防止用户传特别大的数，导致数据库查询阻塞

    class Meta:
        unknown = EXCLUDE

class ResponseSchema(BaseSchema):
    uuid = fields.UUID(required=False)
    create_at = fields.DateTime(required=False, default=datetime.now)
    update_at = fields.DateTime(required=False, default=datetime.now)

    class Meta:
        unknown = INCLUDE
