'''
Author: your name
Date: 2021-04-14 14:12:18
LastEditTime: 2021-07-13 15:13:56
LastEditors: Please set LastEditors
Description: In User Settings Edit
FilePath: \evm-store\backend\schema\apps.py
'''
from datetime import datetime
from . import BaseSchema
from marshmallow import fields, validate, RAISE, INCLUDE, EXCLUDE

class AddSchema(BaseSchema):
    app_name = fields.String(required=True)
    app_version = fields.String(required=False)
    app_desc = fields.String(required=False)
    category = fields.String(required=False)
    logo = fields.Raw(required=False)
    algorithm = fields.String(required=False)
    fileList = fields.List(fields.Raw, required=False)
    sort = fields.Int(required=False, default=0)

    class Meta:
        unknown = EXCLUDE

class UpdateSchema(BaseSchema):
    app_name = fields.String(required=False)
    app_version = fields.String(required=False)
    app_desc = fields.String(required=False)
    category = fields.String(required=False)
    sort = fields.Int(required=False)

    class Meta:
        unknown = EXCLUDE

class DeleteSchema(BaseSchema):
    class Meta:
        unknown = EXCLUDE

class QuerySchema(BaseSchema):
    uuid = fields.UUID(required=False)
    app_name = fields.String(required=False)
    category = fields.String(required=False)
    scope_type = fields.String(required=False)
    algorithm = fields.String(required=False)
    pagenum = fields.Int(required=False)
    pagesize = fields.Int(required=False, max=50) # 防止用户传特别大的数，导致数据库查询阻塞

    class Meta:
        unknown = EXCLUDE

class ResponseSchema(BaseSchema):
    uuid = fields.UUID(required=True)
    create_at = fields.DateTime(required=False, default=datetime.now)
    update_at = fields.DateTime(required=False, default=datetime.now)

    class Meta:
        unknown = INCLUDE
