from datetime import datetime
from . import BaseSchema
from marshmallow import fields, validate, RAISE, INCLUDE, EXCLUDE

class AddSchema(BaseSchema):
    name = fields.String(required=True, validate=validate.Length(min=2, max=50))

    class Meta:
        unknown = EXCLUDE

class UpdatePasswordSchema(BaseSchema):
    uuid = fields.UUID(required=True)
    password = fields.String(required=True, validate=validate.Length(min=6, max=50))
    newPassword = fields.String(required=True, validate=validate.Length(min=6, max=50))

    class Meta:
        unknown = EXCLUDE

class ApplicationBuildSchema(BaseSchema):
    access_key = fields.UUID(required=True)
    app_name = fields.String(required=True)
    app_version = fields.String(required=True)
    category = fields.String(required=True)
    app_desc = fields.String(required=False)

    class Meta:
        unknown = INCLUDE

class DeleteSchema(BaseSchema):
    class Meta:
        unknown = EXCLUDE

class QuerySchema(BaseSchema):
    uuid = fields.UUID(required=False)
    scope_type = fields.String(required=False)
    name = fields.String(required=False, validate=validate.Length(min=2, max=20))
    pagenum = fields.Int(required=False)
    pagesize = fields.Int(required=False, max=50) # 防止用户传特别大的数，导致数据库查询阻塞

    class Meta:
        unknown = EXCLUDE

class ResponseSchema(BaseSchema):
    uuid = fields.UUID(required=True)
    name = fields.String(required=True, validate=validate.Length(min=2, max=50))
    create_at = fields.DateTime(required=False, default=datetime.now)
    update_at = fields.DateTime(required=False, default=datetime.now)

    class Meta:
        unknown = INCLUDE

class GetRoleUser(BaseSchema):
    roles = fields.List(fields.String, required=True)

    class Meta:
        unknown = EXCLUDE

class ConvertString(BaseSchema):
    string = fields.String(required=True)

    class Meta:
        unknown = EXCLUDE

class ExportProject(BaseSchema):
    project = fields.List(fields.String, required=True)
    production = fields.List(fields.String, required=True)
    condition = fields.Dict(required=False)

    class Meta:
        unknown = EXCLUDE