from datetime import datetime
from . import BaseSchema
from marshmallow import fields, validate, RAISE, INCLUDE, EXCLUDE

class AddSchema(BaseSchema):
    title = fields.String(required=True)
    path = fields.String(required=True)
    size = fields.Float(required=True)
    remarks = fields.String(required=False)

    class Meta:
        unknown = EXCLUDE

class UpdateSchema(BaseSchema):
    path = fields.String(required=False)
    type = fields.Int(required=False)
    size = fields.Float(required=False)
    remarks = fields.String(required=False)

    class Meta:
        unknown = EXCLUDE

class DeleteSchema(BaseSchema):
    class Meta:
        unknown = EXCLUDE

class QuerySchema(BaseSchema):
    uuid = fields.UUID(required=False)
    title = fields.String(required=False)

    class Meta:
        unknown = EXCLUDE

class ResponseSchema(BaseSchema):
    uuid = fields.UUID(required=False)
    title = fields.String(required=False)
    path = fields.String(required=False)
    type = fields.Int(required=False)
    size = fields.Float(required=False)
    create_at = fields.DateTime(required=False, default=datetime.now)
    update_at = fields.DateTime(required=False, default=datetime.now)

    class Meta:
        unknown = INCLUDE
