#!/usr/bin/env python
# -*- coding: utf_8 -*-

import uuid
from datetime import datetime
from pony.orm import PrimaryKey, Required, Optional
from app import config
from . import fullStackDB

db = fullStackDB.db

class LoginLogs(db.Entity):
    _table_ = "{}".format(config['TABLE_PREFIX']) + "login_logs"
    id = PrimaryKey(int, auto=True)
    uuid = Required(uuid.UUID, unique=True, default=uuid.uuid1, index=True)
    username = Optional(str)
    ip = Optional(str)
    address = Optional(str)
    create_at = Required(datetime, default=datetime.now)
    create_by = Optional("User", reverse='login_logs_creater')
    sort = Optional(int, size=32, default=0)
    remarks = Optional(str, default="", nullable=True)
