#!/usr/bin/env python
# -*- coding: utf_8 -*-

import uuid
from datetime import datetime
from pony.orm import PrimaryKey, Required, Optional
from app import config
from . import fullStackDB

db = fullStackDB.db

class AppDownload(db.Entity):
    _table_ = "{}".format(config['TABLE_PREFIX']) + "download"
    id = PrimaryKey(int, auto=True)
    uuid = Required(uuid.UUID, unique=True, default=uuid.uuid1, index=True)
    app = Optional("Apps", reverse="app_download")
    imei = Required(str)
    ip = Optional(str)
    address = Optional(str)
    download_at = Required(datetime, default=datetime.now)
    is_delete = Required(bool, default=False)
    sort = Optional(int, size=32, default=0)
    remarks = Optional(str, max_len=255, default="", nullable=True)
