#!/usr/bin/env python
# -*- coding: utf_8 -*-

import uuid
from datetime import datetime
from pony.orm import PrimaryKey, Required, Optional, Json
from app import config
from . import fullStackDB

db = fullStackDB.db

class BuildLogs(db.Entity):
    _table_ = "{}".format(config['TABLE_PREFIX']) + "build_logs"
    id = PrimaryKey(int, auto=True)
    uuid = Required(uuid.UUID, unique=True, default=uuid.uuid1, index=True)
    app = Required("Apps", reverse="app_build_log")
    app_path = Optional(str, default="")
    app_info = Optional(Json, default={})
    source = Optional(int, default=0) # 打包来源 1管理中心 2后端接口
    create_at = Required(datetime, default=datetime.now)
    create_by = Required("User", reverse='build_logs_creator') # BuildLogs与User一对一关系
    update_at = Required(datetime, default=datetime.now)
    update_by = Required("User", reverse='build_logs_updater') # BuildLogs与User一对一关系
    delete_at = Optional(datetime)
    delete_by = Optional("User", reverse='build_logs_deleter') # BuildLogs与User一对一关系
    is_delete = Required(bool, default=False)
    sort = Optional(int, size=32, default=0)
    remarks = Optional(str, max_len=255, default="", nullable=True)