#!/usr/bin/env python
# -*- coding: utf_8 -*-

import uuid
from datetime import datetime
from pony.orm import PrimaryKey, Required, Optional
from app import config
from . import fullStackDB

db = fullStackDB.db

# 当前用户拥有哪些APP
class AppUser(db.Entity):
    _table_ = "{}".format(config['TABLE_PREFIX']) + "app_user"
    id = PrimaryKey(int, auto=True)
    uuid = Required(uuid.UUID, unique=True, default=uuid.uuid1, index=True)
    app = Required("Apps", reverse="app_user")
    device = Required("Device", reverse="app_user")
    create_at = Required(datetime, default=datetime.now)
    create_by = Required("User", reverse='app_users_creator')
    update_at = Required(datetime, default=datetime.now)
    update_by = Required("User", reverse='app_users_updater')
    delete_at = Optional(datetime)
    delete_by = Optional("User", reverse='app_users_deleter')
    is_delete = Required(bool, default=False)
    sort = Optional(int, size=32, default=0)
    remarks = Optional(str, max_len=255, default="", nullable=True)