#!/usr/bin/env python
# -*- coding: utf_8 -*-

import uuid
from datetime import datetime
from pony.orm import PrimaryKey, Required, Optional, LongStr
from app import config
from . import fullStackDB

db = fullStackDB.db

class Annex(db.Entity):
    _table_ = "{}".format(config['TABLE_PREFIX']) + "annex"
    id = PrimaryKey(int, auto=True)
    uuid = Required(uuid.UUID, unique=True, default=uuid.uuid1, index=True)
    app = Optional("Apps", reverse="app_annex")
    title = Required(str, max_len=200) # 文件名
    path = Required(LongStr) # 文件路径
    type = Required(int, default=0) # 文件类型 PNG/JPG/GIF/MP3/MP4/DOCX/XLSX/PPT/PDF...
    size = Required(float, default=0) # 文件大小
    create_at = Required(datetime, default=datetime.now)
    create_by = Required("User", reverse="annex_creator") # Annex与User一对一关系
    update_at = Required(datetime, default=datetime.now)
    update_by = Required("User", reverse="annex_updater") # Annex与User一对一关系
    delete_at = Optional(datetime)
    delete_by = Optional("User", reverse="annex_deleter") # Annex与User一对一关系
    is_delete = Required(bool, default=False)
    sort = Optional(int, size=32, default=0)
    remarks = Optional(str, max_len=255, default="", nullable=True)