class ResponseCode(object):
    OK = (200, 'OK')
    NO_DATA = (204, 'No data')
    NO_DATA_FOUND = (404, 'No data found')
    NOTHING_CHANGE = (304, 'Nothing change')
    REQUEST_ERROR = (400, 'Request error')
    PARAMETER_ERROR = (4001, 'Parameter error')
    PARAMETER_NULL = (4002, 'Parameter is null')
    PASSWORD_ERROR = (4003, 'Password error')
    EXISTS_ERROR = (4004, 'Record already exists')
    INVAILD_ROLE_ERROR = (4005, 'Invaild role error')
    ACCOUNT_DISABLED = (4006, 'Account is disabled')
    AUTHORIZATION_ERROR = (401, 'Authentication error')
    INVAILD_REQUEST = (403, 'Invaild request')
    DB_ERROR = (5001, 'Database error')
    SERVER_ERROR = (5002, 'Server error')
    UNKNOWN_ERROR = (5003, 'Unknown error')

def response_result(code, msg=None, data=None, **kwargs):
    if msg is None:
        msg = code[1]
    result = { 'code': code[0], 'message': msg, 'data': data }
    result.update(kwargs)
    return result