'''
Author: your name
Date: 2021-06-29 19:24:32
LastEditTime: 2021-07-05 20:41:32
LastEditors: Please set LastEditors
Description: In User Settings Edit
FilePath: \evm-store\backend\controller\monitor.py
'''
from model.monitor import session, System, Lvgl, Evm, Image, Device, Request, User

class SystemResource(object):
    def get(self):
        result = session.query(System).all()
        print(result)
        return result

    def post(self, params):
        result = System(**params)
        session.add(result)
        return session.commit()
        
    def put(self):
        pass

    def delete(self):
        pass

class LvglResource(object):
    def get(self):
        result = session.query(Lvgl).all()
        print(result)
        return result

    def post(self, params):
        result = Lvgl(**params)
        session.add(result)
        return session.commit()
        
    def put(self):
        pass

    def delete(self):
        pass

class EvmResource(object):
    def get(self):
        result = session.query(Evm).all()
        print(result)
        return result

    def post(self, params):
        result = Evm(**params)
        session.add(result)
        return session.commit()
        
    def put(self):
        pass

    def delete(self):
        pass

class ImageResource(object):
    def get(self):
        result = session.query(Image).all()
        print(result)
        return result

    def post(self, params):
        result = Image(**params)
        session.add(result)
        return session.commit()

    def post_array(self, array, watch):
        t = []
        for a in array:
            a.update({ "watch": watch })
            t.append(Image(**a))
        session.add_all(t)
        return session.commit()
        
    def put(self):
        pass

    def delete(self):
        pass

systemResource = SystemResource()
lvglResource = LvglResource()
evmResource = EvmResource()
imageResource = ImageResource()

def insert_data(msg):
    # 先判断手表imei是否存在，不存在则先注册手表IMEI
    watch_id = -1
    if msg.get("imei"):
        result = session.query(Device).filter_by(imei=msg.get("imei")).first()
        if result:
            watch_id = result.id
        else:
            user = session.query(User).filter(User.account=="evm").first()
            result = Device(imei=msg.get("imei"), name="watch_{}".format(msg.get("imei")), type="watch", create_by=user.id, update_by=user.id)
            session.add(result)
            session.flush()
            session.commit()

            result = session.query(Device).filter_by(imei=msg.get("imei")).first()
            if result:
                watch_id = result.id

    if msg.get("request"):
        msg.get("request").update({ "watch": watch_id })
        result = Request(**msg.get("request"))
        session.add(result)
        session.flush()
        session.commit()

    if msg.get("system"):
        msg.get("system").update({ "watch": watch_id })
        systemResource.post(msg.get("system"))

    if msg.get("lvgl"):
        msg.get("lvgl").update({ "watch": watch_id })
        lvglResource.post(msg.get("lvgl"))

    if msg.get("evm"):
        msg.get("evm").update({ "watch": watch_id })
        evmResource.post(msg.get("evm"))

    if msg.get("image"):
        imageResource.post_array(msg.get("image"), watch_id)

def get_watch_list():
    result = session.query(Device).all()
    tmp = []
    for item in result:
        tmp.append({
            'id': item.id,
            'imei': item.imei
        })
    return tmp

def evm_data(watch, start, end):
    filters = [Evm.watch==watch]
    if start:
        filters.append(Evm.timestamp >= start)
    if end:
        filters.append(Evm.timestamp <= end)
    result = session.query(Evm).filter(*filters).order_by(Evm.timestamp).all()
    temp = []
    for item in result:
        t = item.to_dict()
        if t.get("timestamp"):
            t.update({ 'timestamp': t.get("timestamp").strftime("%Y-%m-%d %H:%M:%S") })
        temp.append(t)

    return temp

def lvgl_data(watch, start, end):
    filters = [Lvgl.watch==watch]
    if start:
        filters.append(Lvgl.timestamp>=start)
    if end:
        filters.append(Lvgl.timestamp<=end)
    result = session.query(Lvgl).filter(*filters).order_by(Lvgl.timestamp).all()
    temp = []
    for item in result:
        t = item.to_dict()
        if t.get("timestamp"):
            t.update({ 'timestamp': t.get("timestamp").strftime("%Y-%m-%d %H:%M:%S") })
        temp.append(t)

    return temp

def image_data(watch, start, end):
    filters = [Image.watch==watch]
    if start:
        filters.append(Image.timestamp>=start)
    if end:
        filters.append(Image.timestamp<=end)
    result = session.query(Image).filter(*filters).order_by(Image.timestamp).all()
    temp = []
    for item in result:
        t = item.to_dict()
        if t.get("timestamp"):
            t.update({ 'timestamp': t.get("timestamp").strftime("%Y-%m-%d %H:%M:%S") })
        temp.append(t)

    return temp

def get_monitor_list(watch, category, start, end):
    # 判断watch是否存在
    w = session.query(Device).filter(Device.id==watch).first()
    if not w:
        return []

    if category == "system":
        return []
    elif category == "image":
        return image_data(watch, start, end)
    elif category == "lvgl":
        return lvgl_data(watch, start, end)
    elif category == "evm":
        return evm_data(watch, start, end)
    else:
        return {
            'evm': evm_data(watch, start, end),
            'lvgl': lvgl_data(watch, start, end),
            'image': image_data(watch, start, end)
        }
