'''
Author: your name
Date: 2021-04-14 14:12:18
LastEditTime: 2021-07-03 11:53:04
LastEditors: Please set LastEditors
Description: In User Settings Edit
FilePath: \evm-store\backend\controller\__init__.py
'''
#!/usr/bin/env python
# -*- coding: utf_8 -*-

import logging
from app import signalManager
from .api_manager import apiManager
from .user_manager import userManager
from .login_manager import loginManager
from .apps_manager import appsManager
from .device_manager import deviceManager
from .download_manager import downloadManager
from .login_logs_manager import loginLogsManager
from .app_logs_manager import appLogsManager
from .build_logs_manager import buildLogsManager

logger = logging.getLogger(__name__)

def initConnect():
    # 系统模块
    signalManager.actionApplicationBuild.connect(appsManager.build)
    signalManager.actionGetConvertString.connect(apiManager.get_escape_text)
    signalManager.actionUpdatePassword.connect(apiManager.update_user_password)
    signalManager.actionOpqcp.connect(apiManager.opqcp)

    # 登录模块
    signalManager.actionLogin.connect(loginManager.login)
    signalManager.actionLogout.connect(loginManager.logout)
    signalManager.actionRegister.connect(loginManager.register)

    # 应用管理
    signalManager.actionAddApp.connect(appsManager.add)
    signalManager.actionDeleteApp.connect(appsManager.delete)
    signalManager.actionGetApp.connect(appsManager.get)
    signalManager.actionGetAppList.connect(appsManager.getList)
    signalManager.actionUpdateApp.connect(appsManager.update)

    # 设备管理
    signalManager.actionAddDevice.connect(deviceManager.add)
    signalManager.actionDeleteDevice.connect(deviceManager.delete)
    signalManager.actionGetDevice.connect(deviceManager.get)
    signalManager.actionGetDeviceList.connect(deviceManager.getList)
    signalManager.actionUpdateDevice.connect(deviceManager.update)

    # 打包记录
    signalManager.actionAddBuildLog.connect(buildLogsManager.add)
    signalManager.actionDeleteBuildLog.connect(buildLogsManager.delete)
    signalManager.actionGetBuildLog.connect(buildLogsManager.get)
    signalManager.actionGetBuildLogList.connect(buildLogsManager.getList)
    signalManager.actionUpdateBuildLog.connect(buildLogsManager.update)

    # 用户登录记录
    signalManager.actionAddLoginLogs.connect(loginLogsManager.add)
    signalManager.actionDeleteLoginLogs.connect(loginLogsManager.delete)
    signalManager.actionGetLoginLogs.connect(loginLogsManager.get)
    signalManager.actionGetLoginLogsList.connect(loginLogsManager.getList)
    signalManager.actionUpdateLoginLogs.connect(loginLogsManager.update)

    # 用户模块
    signalManager.actionCheckUser.connect(userManager.check)
    signalManager.actionAddUser.connect(userManager.add)
    signalManager.actionDeleteUser.connect(userManager.delete)
    signalManager.actionGetUser.connect(userManager.get)
    signalManager.actionGetUserList.connect(userManager.getList)
    signalManager.actionUpdateUser.connect(userManager.update)

    # 应用下载统计模块
    signalManager.actionAddDownload.connect(downloadManager.add)
    signalManager.actionDeleteDownload.connect(downloadManager.delete)
    signalManager.actionGetDownload.connect(downloadManager.get)
    signalManager.actionGetDownloadList.connect(downloadManager.getList)
    signalManager.actionUpdateDownload.connect(downloadManager.update)

    # 应用打包日志
    signalManager.actionAddAppLogs.connect(appLogsManager.add)
    signalManager.actionDeleteAppLogs.connect(appLogsManager.delete)
    signalManager.actionGetAppLogs.connect(appLogsManager.get)
    signalManager.actionGetAppLogsList.connect(appLogsManager.getList)
    signalManager.actionUpdateAppLogs.connect(appLogsManager.update)

initConnect()