'''
Author: your name
Date: 2021-04-14 14:12:18
LastEditTime: 2021-07-03 11:53:43
LastEditors: Please set LastEditors
Description: In User Settings Edit
FilePath: \evm-store\backend\app\signal_manager.py
'''
#!/usr/bin/env python
# -*- coding: utf_8 -*-

from fullstack.event import PySignal

class SignalManager(object):
    # 接口模块
    actionUpdatePassword = PySignal()
    actionBackupDatabase = PySignal()
    actionApplicationBuild = PySignal()
    actionGetConvertString = PySignal()
    actionOpqcp = PySignal()

    # 登录模块
    actionLogin = PySignal()
    actionLogout = PySignal()
    actionRegister = PySignal()

    # 应用管理
    actionAddApp = PySignal()
    actionGetApp = PySignal()
    actionGetAppList = PySignal()
    actionUpdateApp = PySignal()
    actionDeleteApp = PySignal()

    # 应用打包记录
    actionAddBuildLog = PySignal()
    actionGetBuildLog = PySignal()
    actionGetBuildLogList = PySignal()
    actionUpdateBuildLog = PySignal()
    actionDeleteBuildLog = PySignal()

    # 用户模块
    actionCheckUser = PySignal()
    actionAddUser = PySignal()
    actionDeleteUser = PySignal()
    actionGetUser = PySignal()
    actionGetUserList = PySignal()
    actionUpdateUser = PySignal()

    # 系统框架模块
    actionAddDevice = PySignal()
    actionDeleteDevice = PySignal()
    actionGetDevice = PySignal()
    actionGetDeviceList = PySignal()
    actionUpdateDevice = PySignal()

    # 应用下载统计模块
    actionAddDownload = PySignal()
    actionDeleteDownload = PySignal()
    actionGetDownload = PySignal()
    actionGetDownloadList = PySignal()
    actionUpdateDownload = PySignal()

    # 应用打包日志
    actionAddAppLogs = PySignal()
    actionDeleteAppLogs = PySignal()
    actionGetAppLogs = PySignal()
    actionGetAppLogsList = PySignal()
    actionUpdateAppLogs = PySignal()

    # 用户登录日志
    actionAddLoginLogs = PySignal()
    actionDeleteLoginLogs = PySignal()
    actionGetLoginLogs = PySignal()
    actionGetLoginLogsList = PySignal()
    actionUpdateLoginLogs = PySignal()

    def __init__(self):
        super(SignalManager, self).__init__()

signalManager = SignalManager()
