#!/usr/bin/env python
# -*- coding: utf_8 -*-

import os
import configparser

conf = configparser.ConfigParser()
conf.read(os.path.join(os.getcwd(), "config.ini"))

config = dict(
    NAME='evm_store',
    DEBUG=False,
    HOST=conf.get('application', 'host'),
    PORT=int(conf.get('application', 'port')),
    LOGIN_DISABLED=False,
    MD5_SALT="EhuqUkwV",
    SECRET_KEY='secret_key_EhuqUkwV',
    DATABASE=conf.get('database', 'filename'),
    DATABASE_FILE=conf.get('scheduler', 'db'),
    PONY={
        'provider': conf.get('database', 'provider'),
        'filename': "../{}".format(conf.get('database', 'filename')),
        'create_db': True,
    },
    TABLE_PREFIX='evm_store_',
    BACKUP_DIR=conf.get('application', 'backup_dir'),
    UPLOAD_SERVER="{}://{}:{}/".format(conf.get('uploads', 'protocol'), conf.get('uploads', 'host'), conf.get('uploads', 'port')),
    EPK_DIR=conf.get('uploads', 'epk_dir'),
    TEMP_DIR=conf.get('uploads', 'temp_dir'),
    UPLOAD_PATH=os.path.abspath(conf.get('uploads', 'upload_path')),
    UPLOAD_DIR=conf.get('uploads', 'upload_dir'),
    TEMPLATE_PATH=os.path.join(os.getcwd(), "static"),
    STATIC_PATH=os.path.join(os.getcwd(), "static"),
    LOGO=r'''
               ______                               _____              
___      _________  /_     ________________________ __  /______________
__ | /| / /  _ \_  __ \    _  ___/_  ___/  _ \  __ `/  __/  __ \_  ___/
__ |/ |/ //  __/  /_/ /    / /__ _  /   /  __/ /_/ // /_ / /_/ /  /    
____/|__/ \___//_.___/     \___/ /_/    \___/\__,_/ \__/ \____//_/   

Power by EVM Team
    '''
)