#!/usr/bin/env python
# -*- coding: utf_8 -*-

import os
import json
from .signal_manager import signalManager
from .setting import config
import logging
from controller import initConnect

logger = logging.getLogger("ApplicationManager")

def loadSettings(path=None):
    global config
    projectFile = os.sep.join([os.path.dirname(os.getcwd()), "project.json"])
    if os.path.exists(projectFile):
        with open(projectFile, "rb") as f:
            obj = json.loads(f.read())
            config['PORT'] = obj['port']
            for key in config:
                lowerKey = key.lower()
                if lowerKey in obj:
                    config[key] = obj[lowerKey]
                if lowerKey in obj["server"]:
                    config[key] = obj["server"][lowerKey]
                if key == "PONY":
                    config["PONY"]= obj["server"]["db"]
    return config

def initApp():
    global config
    config = loadSettings()
    return config

config = initApp()
