'''
Author: your name
Date: 2021-07-15 09:33:39
LastEditTime: 2021-07-19 17:40:36
LastEditors: Please set LastEditors
Description: In User Settings Edit
FilePath: \evm-store\tools\build_out\webcreator\response.py
'''
# -*- coding: utf_8 -*-

'''
请求方法：
OPTION : 用于获取资源支持的所有 HTTP 方法

HEAD : 用于只获取请求某个资源返回的头信息

GET : 用于从服务器获取资源信息
    完成请求后返回状态码 200 OK

POST : 用于创建新资源
    创建完成后返回状态码 201 Created

PUT : 用于完整的替换资源或者创建指定身份的资源
    如果是创建了资源，则返回 201 Created
    如果是替换了资源，则返回 200 OK

DELETE : 用于删除某个资源
    完成请求后返回状态码 204 No Content

PATCH : 用于局部更新资源
    完成请求后返回状态码 200 OK

================================================================================

状态码：
请求成功
    200：请求执行成功并返回相应数据
    201：创建成功并返回相应资源数据
    202：接受请求，但无法立即完成创建行为
    204：请求执行成功，不返回相应资源数据

重定向
    301：被请求的资源已永久移动到新位置
    302：请求的资源现在临时从不通的URI响应请求
    303：对应当前请求的响应可以在另一个 URI 上被找到，客户端应该使用 GET 方法进行请求
    307：对应当前请求的响应可以在另一个 URI 上被找到，客户端应该保持原有的请求方法进行请求

条件请求
    304：资源自从上次请求后没有再次发生变化，主要使用场景在于实现数据缓存
    409：请求操作和资源的当前状态存在冲突。主要使用场景在于实现并发控制
    412：服务器在验证请求的头字段中给出先决条件时，没能满足其中的一个或多个。主要使用场景在于实现并发控制

客户端错误
    400 : 请求体包含语法错误
    401 : 需要验证用户身份
    403 : 服务器拒绝执行
    404 : 找不到目标资源
    405 : 不允许执行目标方法，响应中应该带有 Allow 头，内容为对该资源有效的 HTTP 方法
    406 : 服务器不支持客户端请求的内容格式
    410 : 被请求的资源已被删除
    413 : POST 或者 PUT 请求的消息实体过大
    415 : 服务器不支持请求中提交的数据的格式
    422 : 请求格式正确，但是由于含有语义错误，无法响应
    428 : 要求先决条件，如果想要请求能成功必须满足一些预设的条件要求先决条件

服务端错误
    500 : 服务器遇到了一个未曾预料的状况，导致了它无法完成对请求的处理
    502 : 作为网关或者代理工作的服务器尝试执行请求时，从上游服务器接收到无效的响应
    501 : 服务器不支持当前请求所需要的某个功能
    503 : 由于临时的服务器维护或者过载，服务器当前无法处理请求

'''

class ResponseCode(object):
    # 通用状态码
    HTTP_SUCCESS = (200, "success")
    HTTP_NO_DATA = (204, "no data")
    HTTP_NO_CHANGE = (304, 'nothing change')
    HTTP_AUTH_FAIL = (401, 'authentication failed')
    HTTP_INVAILD_REQUEST = (403, 'invaild request')
    HTTP_NOT_FOUND = (404, "not found")
    HTTP_SERVER_ERROR = (500, "server error")


    # 用户模块
    USER_NOT_EXISTS = (1010001, 'user not exists')
    USER_EXISTS = (1010002, 'user already exists')
    USER_PASSWORD_ERROR = (1010003, 'password error')

    # 应用模块
    APPLICATION_NOT_EXISTS = (3010001, 'application not exists')
    APPLICATION_EXISTS = (3010002, 'application already exists')

    # 文件管理模块
    FILE_NOT_EXISTS = (3010001, 'file not exists')
    FILE_EXISTS = (3010002, 'file already exists')
    DIRECTORY_NOT_EXISTS = (3010003, 'directory not exists')
    DIRECTORY_EXISTS = (3010004, 'directory already exists')

    # 设备管理模块
    DEVICE_NOT_EXISTS = (3010001, 'device not exists')
    DEVICE_EXISTS = (3010002, 'device already exists')
    IMEI_NOT_EXISTS = (3010001, 'device imei not exists')
    IMEI_EXISTS = (3010002, 'device imei already exists')


def response_result(response, msg=None, data=None, **kwargs):
    c, m = response
    if msg == None:
        msg = m

    result = { 'code': c, 'msg': msg, 'data': data }
    result.update(kwargs)
    return result
