#!/usr/bin/env python
# -*- coding: utf_8 -*-

from flask import current_app, jsonify, request
from flask_restful import Resource
from flask_restful.reqparse import RequestParser
from flask_jwt_extended import ( jwt_required, get_jwt_identity )
from application.signal_manager import signalManager
from models.monitorLvgl import  getListMonitorLvglSchema, getListMonitorLvglsSchema, getMonitorLvglSchema
from webcreator.log import logger
from webcreator.response import ResponseCode, response_result

class MonitorLvglResourceList(Resource):
    def __init__(self):
        pass
        # 特殊参数，即不是从json获取参数的接口，可以将这个注释打开
        # self.parser = RequestParser()

    def get(self):
        # 特殊参数，即不是从json获取参数的接口，可以将这个注释打开
        # self.parser.add_argument("page", type=int, location="args", default=1)
        # self.parser.add_argument("pageSize", type=int, location="args", default=15)
        # args = self.parser.parse_args()

        try:
            json_payload = request.json
            logger.warn(json_payload)
            data = getListMonitorLvglSchema.load(json_payload)
            result, message = signalManager.actionGetlistMonitorLvgl.emit(data)
            json_dumps = getListMonitorLvglSchema.dump(result)
            if result:
                json_dumps = getListMonitorLvglsSchema.dump(result.items)
                logger.warn(json_dumps)
                return response_result(message, data=json_dumps, count=result.total)
            return response_result(message)
        except Exception as e:
            current_app.logger.error(e)
            return response_result(ResponseCode.HTTP_SERVER_ERROR)

class MonitorLvglResource(Resource):
    def __init__(self):
        pass
        # 特殊参数，即不是从json获取参数的接口，可以将这个注释打开
        # self.parser = RequestParser()

    @jwt_required(locations=["headers"])
    def get(self, uuid):
        # 特殊参数，即不是从json获取参数的接口，可以将这个注释打开
        # self.parser.add_argument("page", type=int, location="args", default=1)
        # self.parser.add_argument("pageSize", type=int, location="args", default=15)
        # args = self.parser.parse_args()

        try:
            json_payload = request.json
            print("========>", uuid, json_payload)
            data = getMonitorLvglSchema.load(json_payload)
            result, message = signalManager.actionGetMonitorLvgl.emit(uuid, data)
            if result:
                json_dumps = getMonitorLvglSchema.dump(result)
                return response_result(message, data=json_dumps)
            return response_result(message)
        except Exception as e:
            current_app.logger.error(e)
            return response_result(ResponseCode.HTTP_SERVER_ERROR)
