#!/usr/bin/env python
# -*- coding: utf_8 -*-

from flask import current_app, jsonify, request
from flask_restful import Resource
from flask_restful.reqparse import RequestParser
from flask_jwt_extended import ( jwt_required, get_jwt_identity )
from application.signal_manager import signalManager
from models.annex import  deleteAnnexSchema, getListAnnexSchema, getListAnnexsSchema, getAnnexSchema
from webcreator.log import logger
from webcreator.response import ResponseCode, response_result


class AnnexResourceList(Resource):
    def __init__(self):
        pass
        # 特殊参数，即不是从json获取参数的接口，可以将这个注释打开
        # self.parser = RequestParser()

    def get(self):
        # 特殊参数，即不是从json获取参数的接口，可以将这个注释打开
        # self.parser.add_argument("page", type=int, location="args", default=1)
        # self.parser.add_argument("pageSize", type=int, location="args", default=15)
        # args = self.parser.parse_args()

        try:
            json_payload = request.json
            logger.warn(json_payload)
            data = getListAnnexSchema.load(json_payload)
            result, message = signalManager.actionGetlistAnnex.emit(data)
            json_dumps = getListAnnexSchema.dump(result)
            if result:
                json_dumps = getListAnnexsSchema.dump(result.items)
                logger.warn(json_dumps)
                return response_result(message, data=json_dumps, count=result.total)
            return response_result(message)
        except Exception as e:
            current_app.logger.error(e)
            return response_result(ResponseCode.HTTP_SERVER_ERROR)

class AnnexResource(Resource):
    def __init__(self):
        pass
        # 特殊参数，即不是从json获取参数的接口，可以将这个注释打开
        # self.parser = RequestParser()

    @jwt_required(locations=["headers"])
    def get(self, uuid):
        # 特殊参数，即不是从json获取参数的接口，可以将这个注释打开
        # self.parser.add_argument("page", type=int, location="args", default=1)
        # self.parser.add_argument("pageSize", type=int, location="args", default=15)
        # args = self.parser.parse_args()

        try:
            json_payload = request.json
            print("========>", uuid, json_payload)
            data = getAnnexSchema.load(json_payload)
            result, message = signalManager.actionGetAnnex.emit(uuid, data)
            if result:
                json_dumps = getAnnexSchema.dump(result)
                return response_result(message, data=json_dumps)
            return response_result(message)
        except Exception as e:
            current_app.logger.error(e)
            return response_result(ResponseCode.HTTP_SERVER_ERROR)


    @jwt_required(locations=["headers"])
    def delete(self, uuid):
        try:
            json_payload = request.json
            print("========>", uuid, json_payload)
            # data = deleteAnnexSchema.load(json_payload)
            result, message = signalManager.actionDeleteAnnex.emit(uuid)
            return response_result(message, data=result)
        except Exception as e:
            current_app.logger.error(e)
            return response_result(ResponseCode.HTTP_SERVER_ERROR)
