'''
Author: your name
Date: 2021-07-27 19:08:58
LastEditTime: 2021-07-28 16:15:39
LastEditors: your name
Description: In User Settings Edit
FilePath: \evm-store\tools\build_out\views\__init__.py
'''
# -*- coding: utf-8 -*-

from flask import Blueprint
from flask_restful import Api
from . import area
from . import app
from . import package
from . import user
from . import login
from . import device
from . import annex
from . import monitorWatch
from . import monitorSystem
from . import monitorLvgl
from . import monitorImage
from . import monitorEvm
from . import menu
from . import file
from . import openapi

api_v1 = Blueprint('api_v1', __name__)

api = Api(api_v1)
api.add_resource(area.AreaResource, '/area/<string:uuid>')
api.add_resource(area.AreaResourceList, '/area')

api.add_resource(app.AppResource, '/app/<string:uuid>')
api.add_resource(app.AppResourceList, '/app')

api.add_resource(package.PackageResource, '/package/<string:uuid>')
api.add_resource(package.PackageResourceList, '/package')

api.add_resource(user.UserResource, '/user/<string:uuid>')
api.add_resource(user.UserResourceList, '/user')

api.add_resource(login.LoginResource, '/login/<string:uuid>')
api.add_resource(login.LoginResourceList, '/login')

api.add_resource(device.DeviceResource, '/device/<string:uuid>')
api.add_resource(device.DeviceResourceList, '/device')

api.add_resource(annex.AnnexResource, '/annex/<string:uuid>')
api.add_resource(annex.AnnexResourceList, '/annex')

api.add_resource(monitorWatch.MonitorWatchResource, '/monitorWatch/<string:uuid>')
api.add_resource(monitorWatch.MonitorWatchResourceList, '/monitorWatch')

api.add_resource(monitorSystem.MonitorSystemResource, '/monitorSystem/<string:uuid>')
api.add_resource(monitorSystem.MonitorSystemResourceList, '/monitorSystem')

api.add_resource(monitorLvgl.MonitorLvglResource, '/monitorLvgl/<string:uuid>')
api.add_resource(monitorLvgl.MonitorLvglResourceList, '/monitorLvgl')

api.add_resource(monitorImage.MonitorImageResource, '/monitorImage/<string:uuid>')
api.add_resource(monitorImage.MonitorImageResourceList, '/monitorImage')

api.add_resource(monitorEvm.MonitorEvmResource, '/monitorEvm/<string:uuid>')
api.add_resource(monitorEvm.MonitorEvmResourceList, '/monitorEvm')

api.add_resource(menu.MenuList, '/menu')
api.add_resource(menu.Batch, '/menu/delete/batch')
api.add_resource(menu.Create, '/menu/create')
api.add_resource(menu.Treelist, '/menu/treeList')
api.add_resource(menu.Treenodes, '/menu/treeNodes')
api.add_resource(menu.Updatebyid, '/menu/updateById')
api.add_resource(menu.UpdateSort, '/menu/updateSort')

api.add_resource(openapi.AppReviewResource, '/api/app-review')
api.add_resource(openapi.CStringToolResource, '/api/convert-to-c-string')
api.add_resource(openapi.BuildAppResource, '/evm_store/application/build')
api.add_resource(openapi.Workbench, '/api/workbench')
api.add_resource(openapi.App, '/api/app')
api.add_resource(openapi.AppInfo, '/api/app-info')
api.add_resource(openapi.LauncherResource, '/api/app-launcher')
api.add_resource(openapi.AppListResource, '/api/app-list')
api.add_resource(openapi.DownloadEpk, '/api/download-epk')

api.add_resource(file.FileInit, "/file-manager/initialize")
api.add_resource(file.FileContent, "/file-manager/content")
api.add_resource(file.FileDisk, "/file-manager/select-disk")
api.add_resource(file.FileTree, "/file-manager/tree")
api.add_resource(file.FileUpdate, "/file-manager/update-file")
api.add_resource(file.FileUpload, "/file-manager/upload")
api.add_resource(file.FileDownload, "/file-manager/download")
api.add_resource(file.FilePrview, "/file-manager/preview")
api.add_resource(file.FileCreateDir, "/file-manager/create-directory")
api.add_resource(file.FileCreate, "/file-manager/create-file")
api.add_resource(file.FilePaste, "/file-manager/paste")
api.add_resource(file.FileDelete, "/file-manager/delete")
