# -*- coding: utf-8 -*-
import os
import multiprocessing

MODE = 'develop'  # develop: 开发模式; production: 生产模式

class ProductionConfig(object):
    EPK_DIR = "D:\\projects\\scriptiot\\evm_app_store_files\\epks"
    UPLOAD_ROOT_DIR = "D:\\projects\\scriptiot\\evm_app_store_files"
    UPLOAD_ALLOWED = set(['doc', 'docs', 'csv', 'xls', 'xlsx'])
    BIND = '127.0.0.1:3001'
    WORKERS = multiprocessing.cpu_count() * 2 + 1
    WORKER_CONNECTIONS = 10000
    BACKLOG = 64
    TIMEOUT = 60
    LOG_LEVEL = 'INFO'
    LOG_DIR_PATH = os.path.join(os.path.dirname(__file__), 'logs')
    LOG_FILE_MAX_BYTES = 1024 * 1024 * 100
    LOG_FILE_BACKUP_COUNT = 10
    PID_FILE = 'run.pid'
    REDIS_HOST = '127.0.0.1'
    REDIS_PORT = 6379
    REDIS_PASSWORD = ''
    REDIS_MAX_CONNECTIONS = 100
    JWT_HEADER_NAME = 'Authorization'
    JWT_HEADER_TYPE = 'Bearer'
    JWT_SECRET_KEY = '6UdxRgs2hvWpTLmj027d5vt7dXXQX'
    JWT_ACCESS_TOKEN_EXPIRES = 7200
    JWT_REFRESH_TOKEN_EXPIRES = 1800
    MYSQL_DB = 'qianjing_iot'
    MYSQL_HOST = '127.0.0.1'
    MYSQL_PORT = 3306
    MYSQL_USER = 'debian-sys-maint'
    MYSQL_PWD = 'XMigC2B2uugnv18y'
    SQLALCHEMY_BINDS = {
        'app-store':      'sqlite:///../test.db'
    }
    SQLALCHEMY_DATABASE_URI = 'sqlite:///../test.db'

    def __init__(self):
        super().__init__()

        self.SQLALCHEMY_DATABASE_URI = 'sqlite:///../test.db'


class DevelopConfig(object):
    EPK_DIR = "D:\\projects\\scriptiot\\evm_app_store_files\\epks"
    UPLOAD_ROOT_DIR = "D:\\projects\\scriptiot\\evm_app_store_files"
    UPLOAD_ALLOWED = set(['doc', 'docs', 'csv', 'xls', 'xlsx'])
    BIND = '127.0.0.1:3001'
    WORKERS = 2
    WORKER_CONNECTIONS = 1000
    BACKLOG = 64
    TIMEOUT = 30
    LOG_LEVEL = 'DEBUG'
    LOG_DIR_PATH = os.path.join(os.path.dirname(__file__), 'logs')
    LOG_FILE_MAX_BYTES = 1024 * 1024
    LOG_FILE_BACKUP_COUNT = 1
    PID_FILE = 'run.pid'
    REDIS_HOST = '127.0.0.1'
    REDIS_PORT = 6379
    REDIS_PASSWORD = ''
    REDIS_MAX_CONNECTIONS = 100
    JWT_HEADER_NAME = 'Authorization'
    JWT_HEADER_TYPE = 'Bearer'
    JWT_SECRET_KEY = '6UdxRgs2hvWpTLmj027d5vt7dXXQX'
    JWT_ACCESS_TOKEN_EXPIRES = 7200
    JWT_REFRESH_TOKEN_EXPIRES = 1800
    MYSQL_DB = 'qianjing_iot'
    MYSQL_HOST = '127.0.0.1'
    MYSQL_PORT = 3306
    MYSQL_USER = 'debian-sys-maint'
    MYSQL_PWD = 'XMigC2B2uugnv18y'
    SQLALCHEMY_BINDS = {
        'app-store':      'sqlite:///../evue-store.db'
    }
    SQLALCHEMY_DATABASE_URI = 'sqlite:///../evue-store.db'
    SQLALCHEMY_TRACK_MODIFICATIONS = True
    SQLALCHEMY_ECHO = False

    def __init__(self):
        super().__init__()

        self.SQLALCHEMY_DATABASE_URI = 'sqlite:///../evue-store.db'

if MODE == 'production':
    config = ProductionConfig()
else:
    config = DevelopConfig()
