#!/usr/bin/env python
# -*- coding: utf_8 -*-

import uuid
from datetime import datetime, date
from pony.orm import PrimaryKey, Required, Optional, Set
from app import config
from . import fullStackDB

db = fullStackDB.db

class User(db.Entity):
    _table_ = "{}".format(config['TABLE_PREFIX']) + "user"
    id = PrimaryKey(int, auto=True)
    uuid = Required(uuid.UUID, unique=True, default=uuid.uuid1, index=True)
    role = Required(str, default="community") # 角色，管理员[administrator]、企业用户[enterprise]、社区用户[community]
    account = Required(str, unique=True) # 账号
    username = Required(str, max_len=100) # 用户名
    password = Required(str, max_len=64) # 密码
    gender = Optional(int, size=8, default=1) # 性别，未知0 男1 女2
    birthday = Optional(date, default=date.today()) # 使用age会带来age无法随时间变化问题
    phone = Optional(str, max_len=11, default="") # 联系方式
    email = Optional(str, max_len=100, default="") # 邮箱
    create_at = Required(datetime, default=datetime.now)
    create_by = Required(int)
    update_at = Required(datetime, default=datetime.now)
    update_by = Required(int)
    delete_at = Optional(datetime)
    delete_by = Optional(int)
    is_delete = Required(bool, default=False)
    sort = Optional(int, size=32, default=0)
    remarks = Optional(str, max_len=255, default="", nullable=True)
    app_logs_creater = Set('AppLogs', reverse='create_by')
    login_logs_creater = Set('LoginLogs', reverse='create_by')
    annex_creator = Set('Annex', reverse='create_by')
    annex_updater = Set('Annex', reverse='update_by')
    annex_deleter = Set('Annex', reverse='delete_by')
    apps_creator = Set('Apps', reverse='create_by')
    apps_updater = Set('Apps', reverse='update_by')
    apps_deleter = Set('Apps', reverse='delete_by')
    app_users_creator = Set('AppUser', reverse='create_by')
    app_users_updater = Set('AppUser', reverse='update_by')
    app_users_deleter = Set('AppUser', reverse='delete_by')
    build_logs_creator = Set('BuildLogs', reverse='create_by')
    build_logs_updater = Set('BuildLogs', reverse='update_by')
    build_logs_deleter = Set('BuildLogs', reverse='delete_by')
    device_creator = Set('Device', reverse='create_by')
    device_updater = Set('Device', reverse='update_by')
    device_deleter = Set('Device', reverse='delete_by')
