#!/usr/bin/env python
# -*- coding: utf_8 -*-

import uuid
from datetime import datetime
from pony.orm import PrimaryKey, Required, Optional
from app import config
from . import fullStackDB

db = fullStackDB.db

class Dict(db.Entity):
    _table_ = "{}".format(config['TABLE_PREFIX']) + "dictionary"
    id = PrimaryKey(int, auto=True)
    uuid = Required(uuid.UUID, unique=True, default=uuid.uuid1, index=True)
    label = Required(str)
    value = Required(str)
    category = Required(str)
    is_system = Required(bool, default=False) # 能否删除
    create_at = Required(datetime, default=datetime.now)
    create_by = Required("User", reverse='dict_creator') # Dict与User一对一关系
    update_at = Required(datetime, default=datetime.now)
    update_by = Required("User", reverse='dict_updater') # Dict与User一对一关系
    delete_at = Optional(datetime)
    delete_by = Optional("User", reverse='dict_deleter') # Dict与User一对一关系
    is_delete = Required(bool, default=False)
    sort = Optional(int, size=32, default=0)
    remarks = Optional(str, max_len=255, default="", nullable=True)
