#!/usr/bin/env python
# -*- coding: utf_8 -*-

import uuid
from datetime import datetime
from pony.orm import PrimaryKey, Required, Optional, Set
from app import config
from . import fullStackDB

db = fullStackDB.db

class Device(db.Entity):
    _table_ = "{}".format(config['TABLE_PREFIX']) + "device"
    id = PrimaryKey(int, auto=True)
    uuid = Required(uuid.UUID, unique=True, default=uuid.uuid1, index=True)
    name = Required(str) # 名称
    imei = Required(str) # IMEI
    desc = Optional(str) # 描述信息
    type = Optional(str)  # 设备类型
    app_user = Set("AppUser", reverse="device")
    create_at = Required(datetime, default=datetime.now)
    create_by = Required("User", reverse='device_creator')
    update_at = Required(datetime, default=datetime.now)
    update_by = Required("User", reverse='device_updater')
    delete_at = Optional(datetime)
    delete_by = Optional("User", reverse='device_deleter')
    is_delete = Required(bool, default=False)
    sort = Optional(int, size=32, default=0)
    remarks = Optional(str, max_len=255, default="", nullable=True)