#!/usr/bin/env python
# -*- coding: utf_8 -*-

import uuid
from datetime import datetime
from pony.orm import PrimaryKey, Required, Optional, Set
from app import config
from . import fullStackDB

# ********************************
from .app_users import AppUser
# ********************************

db = fullStackDB.db

class Apps(db.Entity):
    _table_ = "{}".format(config['TABLE_PREFIX']) + "apps"
    id = PrimaryKey(int, auto=True)
    uuid = Required(uuid.UUID, unique=True, default=uuid.uuid1, index=True)
    app_name = Required(str, max_len=200)
    app_version = Optional(str, default="")
    app_url = Optional(str, default="")
    category = Optional(str, default="")
    app_icon = Optional(str)
    app_desc = Optional(str, default="")
    app_annex = Set("Annex", reverse="app", cascade_delete=True)
    app_user = Optional("AppUser", reverse="app", cascade_delete=True)
    app_build_log = Optional("BuildLogs", reverse="app", cascade_delete=True)
    app_download = Set("AppDownload", reverse="app", cascade_delete=True)
    create_at = Required(datetime, default=datetime.now)
    create_by = Required("User", reverse='apps_creator') # BuildLogs与User一对一关系
    update_at = Required(datetime, default=datetime.now)
    update_by = Required("User", reverse='apps_updater') # BuildLogs与User一对一关系
    delete_at = Optional(datetime)
    delete_by = Optional("User", reverse='apps_deleter') # BuildLogs与User一对一关系
    is_delete = Required(bool, default=False)
    sort = Optional(int, size=32, default=0)