#!/usr/bin/env python
# -*- coding: utf_8 -*-

import uuid
from datetime import datetime
from pony.orm import PrimaryKey, Required, Optional, Json
from app import config
from . import fullStackDB

db = fullStackDB.db

class AppLogs(db.Entity):
    _table_ = "{}".format(config['TABLE_PREFIX']) + "app_logs"
    id = PrimaryKey(int, auto=True)
    uuid = Required(uuid.UUID, unique=True, default=uuid.uuid1, index=True)
    app_name = Optional(str)
    app_path = Optional(str, default="")
    app_version = Optional(str, default="")
    app_info = Optional(Json, default={})
    create_at = Required(datetime, default=datetime.now)
    create_by = Optional("User", reverse='app_logs_creater')
    sort = Optional(int, size=32, default=0)
    remarks = Optional(str, max_len=255, default="", nullable=True)
