'''
Author: your name
Date: 2021-07-22 19:01:41
LastEditTime: 2021-07-26 17:41:15
LastEditors: Please set LastEditors
Description: In User Settings Edit
FilePath: \evm-store\tools\build_out\tests\http_interval.py
'''
import json
import time
import random
import requests
from threading import Timer, Thread

def send_request(imei):
    payload = {
        "system": {"free_size": 1769792, "free_space_size": 5156864, "used_space_size": 1134592},
        "lvgl": {"total_size": 100, "free_cnt": 50, "free_size": 23, "free_biggest_size": 53, "used_cnt": 78, "used_pct":43, "frag_pct": 0},
        "evm": {"heap_total_size": 2097152, "heap_used_size": 575072, "heap_map_size": 8192, "stack_total_size": 102400, "stack_used_size": 1312},
        "image": [
            {"uri": "evue_launcher", "length": 13515, "png_total_count": 0,
                "png_uncompressed_size": 0, "png_file_size": 0},
            {"uri": "kdgs_1_startup", "length": 3666, "png_total_count": 0,
                "png_uncompressed_size": 0, "png_file_size": 0},
            {"uri": "kdgs_1_index", "length": 5482, "png_total_count": 0,
                "png_uncompressed_size": 0, "png_file_size": 0},
            {"uri": "kdgs_1_story", "length": 5509, "png_total_count": 0,
                "png_uncompressed_size": 0, "png_file_size": 0},
            {"uri": "kdgs_1_storyList", "length": 9196, "png_total_count": 0,
                "png_uncompressed_size": 0, "png_file_size": 0},
            {"uri": "kdgs_1_storyPlay", "length": 25791, "png_total_count": 6, "png_uncompressed_size": 319376, "png_file_size": 10770, "png_detail": [
                {
                    "uri": "C:/../../test/watch_appstore/kdgs_1_playBackground.png",
                    "filesize": 7774,
                    "uncompressed_size": 259200,
                    "ratio": 33.341908
                },
                {
                    "uri": "C:/../../test/watch_appstore/kdgs_1_playLb.png",
                    "filesize": 482,
                    "uncompressed_size": 12544,
                    "ratio": 26.024897
                },
                {
                    "uri": "C:/../../test/watch_appstore/kdgs_1_playNLike.png",
                    "filesize": 1094,
                    "uncompressed_size": 12544,
                    "ratio": 11.466179
                },
                {
                    "uri": "C:/../../test/watch_appstore/kdgs_1_playYl.png",
                    "filesize": 745,
                    "uncompressed_size": 12544,
                    "ratio": 16.837584
                },
                {
                    "uri": "C:/../../test/watch_appstore/kdgs_1_playNext.png",
                    "filesize": 484,
                    "uncompressed_size": 12544,
                    "ratio": 25.917355
                },
                {
                    "uri": "C:/../../test/watch_appstore/kdgs_1_play_bs.png",
                    "filesize": 191,
                    "uncompressed_size": 10000,
                    "ratio": 52.356022
                }
            ]}
        ],
        "imei": imei, "datetime": {"second": 55, "minute": 48, "hour": 15, "day": 21, "month": 7, "year": 2021, "weekday": 3}
    }

    while True:
        for item in payload.get("image"):
            item.update({
                'length': 0,
                'png_total_count': 0,
                'png_uncompressed_size': 0,
                'png_file_size': 0
            })

        rand_index = random.randint(0, len(payload.get("image")))
        if rand_index < len(payload.get("image")):
            print("------------------------------>")
        else:
            rand_index = rand_index - 1
            print("rand_index ==>", rand_index)

        payload.get("image")[rand_index].update({
            'length': random.randint(0, 10000),
            'png_total_count': random.randint(0, 10000),
            'png_uncompressed_size': random.randint(100, 100000),
            'png_file_size': random.randint(0, 10000)
        })

        r = requests.post("http://localhost:3000/api/v1/evm_store/monitor", data=json.dumps(payload))

        print(r.status_code)
        print(r.json())

        time.sleep(3)


class myThread(Thread):
    def __init__(self, threadID, name, counter, imei):
        Thread.__init__(self)
        self.threadID = threadID
        self.name = name
        self.counter = counter
        self.imei = imei

    def run(self):
        print("开始线程：" + self.name)
        print(self.counter, self.imei)
        send_request(self.imei)
        print("退出线程：" + self.name)


if __name__ == "__main__":
    # send_request()

    # 创建新线程
    thread1 = myThread(1, "Thread-1", 1, "352099001761481")
    thread2 = myThread(2, "Thread-2", 2, "866866040000447")

    # 开启新线程
    thread1.start()
    thread2.start()
    thread1.join()
    thread2.join()
    print("退出主线程")
