#!/usr/bin/env python
# -*- coding: utf_8 -*-

from flask import current_app, jsonify, request
from flask_restful import Resource
from flask_restful.reqparse import RequestParser
from flask_jwt_extended import ( jwt_required, get_jwt_identity )
from application.signal_manager import signalManager
{%- set pipe = joiner(",") %}
from models.{{ config['name'] }} import {% for k, v in config["view"].items() -%}
{{ pipe() }} {{ k }}{{ config['name'] | letterUpper }}Schema{% if k == "getList" %}{{ pipe() }} {{ k }}{{ config['name'] | letterUpper }}sSchema{% endif %}
{%- endfor %}
from webcreator.log import logger
from webcreator.response import ResponseCode, response_result

class {{ config['name'] | letterUpper }}ResourceList(Resource):
    def __init__(self):
        pass
        # 特殊参数，即不是从json获取参数的接口，可以将这个注释打开
        # self.parser = RequestParser()

{%- if config["view"]["getList"] %}
{% if config["view"]["getList"]["auth"] %}
    @jwt_required(locations=["headers"])
{%- endif %}
    def get(self):
        # 特殊参数，即不是从json获取参数的接口，可以将这个注释打开
        # self.parser.add_argument("page", type=int, location="args", default=1)
        # self.parser.add_argument("pageSize", type=int, location="args", default=15)
        # args = self.parser.parse_args()

        try:
            json_payload = request.json
            logger.warn(json_payload)
            data = getList{{ config['name'] | letterUpper }}Schema.load(json_payload)
            result, message = signalManager.actionGetList{{ config["name"] | letterUpper }}.emit(data)
            json_dumps = getList{{ config['name'] | letterUpper }}Schema.dump(result)
            if result:
                json_dumps = getList{{ config['name'] | letterUpper }}sSchema.dump(result.items)
                logger.warn(json_dumps)
                return response_result(message, data=json_dumps, count=result.total)
            return response_result(message)
        except Exception as e:
            current_app.logger.error(e)
            return response_result(ResponseCode.HTTP_SERVER_ERROR)
{%- endif %}

{%- if config["view"]["post"] %}
{% if config["view"]["post"]["auth"] %}
    @jwt_required(locations=["headers"])
{%- endif %}
    def post(self):
        try:
            json_payload = request.json
            data = post{{ config['name'] | letterUpper }}Schema.load(json_payload)
            result, message = signalManager.actionPost{{ config["name"] | letterUpper }}.emit(data)
            logger.info(result)
            logger.warn(message)
            return response_result(message)
        except Exception as e:
            current_app.logger.error(e)
            return response_result(ResponseCode.HTTP_SERVER_ERROR)
{% endif %}

class {{ config['name'] | letterUpper }}Resource(Resource):
    def __init__(self):
        pass
        # 特殊参数，即不是从json获取参数的接口，可以将这个注释打开
        # self.parser = RequestParser()

{%- if config["view"]["get"] %}
{% if config["view"]["get"]["auth"] %}
    @jwt_required(locations=["headers"])
{%- endif %}
    def get(self, uuid):
        # 特殊参数，即不是从json获取参数的接口，可以将这个注释打开
        # self.parser.add_argument("page", type=int, location="args", default=1)
        # self.parser.add_argument("pageSize", type=int, location="args", default=15)
        # args = self.parser.parse_args()

        try:
            json_payload = request.json
            print("========>", uuid, json_payload)
            data = get{{ config['name'] | letterUpper }}Schema.load(json_payload)
            result, message = signalManager.actionGet{{ config["name"] | letterUpper }}.emit(uuid, data)
            if result:
                json_dumps = get{{ config['name'] | letterUpper }}Schema.dump(result)
                return response_result(message, data=json_dumps)
            return response_result(message)
        except Exception as e:
            current_app.logger.error(e)
            return response_result(ResponseCode.HTTP_SERVER_ERROR)
{% endif %}

{%- if config["view"]["put"] %}
{% if config["view"]["put"]["auth"] %}
    @jwt_required(locations=["headers"])
{%- endif %}
    def put(self, uuid):
        try:
            json_payload = request.json
            print("========>", uuid, json_payload)
            data = put{{ config['name'] | letterUpper }}Schema.load(json_payload)
            result, message = signalManager.actionPut{{ config["name"] | letterUpper }}.emit(uuid, data)
            logger.info(result)
            logger.info(message)
            return response_result(message, data=result)
        except Exception as e:
            current_app.logger.error(e)
            return response_result(ResponseCode.HTTP_SERVER_ERROR)
{% endif %}

{%- if config["view"]["delete"] %}
{% if config["view"]["delete"]["auth"] %}
    @jwt_required(locations=["headers"])
{%- endif %}
    def delete(self, uuid):
        try:
            json_payload = request.json
            print("========>", uuid, json_payload)
            # data = delete{{ config['name'] | letterUpper }}Schema.load(json_payload)
            result, message = signalManager.actionDelete{{ config["name"] | letterUpper }}.emit(uuid)
            return response_result(message, data=result)
        except Exception as e:
            current_app.logger.error(e)
            return response_result(ResponseCode.HTTP_SERVER_ERROR)
{% endif %}
